@extends('layout.default')
@section('content')
    <style>
        .cancel{
            width: 60px;
            height: 60px;
            background: url(https://image.flaticon.com/icons/svg/189/189678.svg)center  no-repeat;
            background-size: 35px 35px;
            background-color:lightsteelblue;
        }
    </style>
<div class="container-fluid">
    <div class="row" style="margin: 3%;">
        <div class="col-md-12 rounded border border-light" style="background: #f6993f ;padding-bottom: 2%">
            <div style="padding-top: 3%"><h1 style="font-weight: bolder;font-size:24pt;text-align: center;color:white;">目前正在儲存錄製的設備</h1></div>
            <div class="row" style="overflow-y: scroll;">
                <table id="recording_table" class="table table-striped" style="text-align: center;">
                    <thead>
                    <tr>
                        <th scope="col">#</th>
                        <th scope="col">群組名稱</th>
                        <th scope="col">頻道</th>
                        <th scope="col">設備編號</th>
                        <th scope="col">開始儲存時間</th>
                        <th scope="col">停止儲存</th>
                    </tr>
                    </thead>
                    <tbody id = recording_info>
                    </tbody>
                </table>
            </div>
        </div>
    </div>
    <div class="row" style="margin-top:3%;margin-left:3%;font-weight: bolder;font-size:24pt;text-align: center;color:white;">新增儲存錄製設備</div>
    <div class="row" style="margin-left: 3%;font-size:18pt;">
        <form id="send" action="http://60.249.6.104:10300/storage_cam" method="POST"  onsubmit="return false">
            <div class="form-group row">
                <div class="col-auto">
                <div class="row">
                <label for="goup_name">群組名稱</label>
                </div>
                    <div class="row">
                    <button  class="btn-light rounded dropdown-toggle" type="button" id="dropdownMenu1" data-toggle="dropdown" aria-haspopup="true" aria-expanded="true">
                        <span  id="seleted_goup">選擇攝影機群組</span>
                        <span class="caret"></span>
                    </button>
                    <ul id="goup_ids" class="dropdown-menu" aria-labelledby="dropdownMenu1">
                        @foreach($Goups as $goup)
                            <li id="l"style="margin-left: 5%" onclick="select_goup('{{$goup->goup_id}}'),goup_name.value='{{$goup->goup_name}}',seleted_goup.innerHTML='{{$goup->goup_name}}'">{{$goup->goup_name}}</li>
                        @endforeach
                    </ul>
                        <input type="text"  hidden="hidden" class="form-control" id="goup_name" name="goup_name">
                    </div>
                </div>
                <div class="col-auto">
                    <label for="cam_ids">設備編號</label>
                    <select onchange="find_channel()" class="form-control" id="cam_ids" name="cam_ids">
                        <option>先選擇群組</option>
                    </select>
                </div>
{{--                <div class="col-2">--}}
{{--                    <label for="camera_path">頻道</label>--}}
                    <input hidden="hidden" type="text"  class="form-control" id="camera_path" name="camera_path" placeholder="channel">
{{--                </div>--}}
                <div class="col-auto">
                    <input style="height: 100%;width: 80px;font-size:18pt;" type="submit" class="btn btn-success">
                </div>
            </div>
        </form>
    </div>
</div>
    <form hidden="hidden" id="cancel_form" action="http://60.249.6.104:10300/rm_container" method="POST" onsubmit="return false">
        <input id="cancel_id" name="camera_id">
        <input id="cancel_submit" type="submit">
    </form>

    <!-- 停止儲警報 -->
    <div class="modal fade" id="cancel_alert" tabindex="-1" role="dialog" aria-labelledby="cancel_alert_Label" aria-hidden="true">
        <div class="modal-dialog" role="document">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title" id="cancel_alert_Label">確定要停止儲存該設備嗎？</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div id="modal-body" class="modal-body">
                    ...
                </div>
                <div id="modal-footer" class="modal-footer">
                    <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
                    <button type="button" class="btn btn-primary" data-dismiss="modal">停止儲存</button>
                </div>
            </div>
        </div>
    </div>

{{--選擇群組後 顯示現有設備--}}
<script>
    function select_goup(goup_id)
    {
        $.ajax({
            type: "GET",
            url: '{{url('recordconfig/select_goup/')}}/'+goup_id,
            dataType: 'json',
            success: function (data) {
                str = '';
                str+="<option>--選擇設備--</option>";
                for (var k in data){
                    str+="<option>"+data[k]['camera_id']+"</option>";
                }
                document.getElementById("cam_ids").innerHTML = str;
            },
            error: function (data) {
                alert(JSON.stringify(data) + '\n' + '發生錯誤')
            }

        });
    }
</script>

{{--選擇設備後 顯示對應頻道--}}
<script>
    function find_channel() {
        var e=document.getElementById('cam_ids');
        var cam_id= e.options[e.selectedIndex].value;
        $.ajax({
            type: "GET",
            url: '{{url('recordconfig/')}}/'+cam_id,
            dataType: 'json',
            success: function (data) {
                for(var k in data) {
                    document.getElementById('camera_path').value = data[k]['camera_path'];
                }
            },
            error: function (data) {
                alert(JSON.stringify(data) + '\n' + '發生錯誤')
            }

        });
    }
</script>

{{--向API 調查目前有在錄製的設備--}}
<script>
    $.ajax({
        type: "GET",
        url: "http://60.249.6.104:10300/storage/list",
        dataType: 'json',
        success: function(data)
        {
            document.getElementById('recording_info').innerHTML='';
            var cam_list=[];
            for (var k in data) {
                var txt='';
                for (i in data[k][0]){
                    if (i <9 ){ continue;}
                    txt+=data[k][0][i];
                }
                txt=txt.toLocaleUpperCase();
                // alert('目前正在儲存的有\n' + JSON.stringify(data[k][0])+'\n'+txt.toLocaleUpperCase());
                cam_list.push(txt);
                // console.log(data);
            }
            get_info(cam_list.sort());
        },
        error:function(data){
            alert(JSON.stringify(data)+'\n'+'發生錯誤');
        }

    });
</script>
{{--    向API請求 停止負責該設備儲存的 containter--}}

<script>
  $("#cancel_form").submit(function (e) {
  var form =$(this);
  var url=form.attr('action');
  $.ajax({
     type:"POST",
     url:url,
     data:form.serialize(),
     dataType:'json',
     success: function (data) {
        alert('伺服器回應\n'+JSON.stringify(data));
        window.location.reload();
     },
     error:function (data) {
        alert(JSON.stringify(data)+'\n發生錯誤');
        window.location.reload();
     }
  });
  e.preventDefault();
});
    function stop_store(id,n) {
    document.getElementById('cancel_id').value=id;
    $('#cancel_submit').click();
    // $('#cancel'+n).style.background='https://image.flaticon.com/icons/svg/726/726210.svg';
    var btn =document.getElementById('cancel'+n);
    btn.style.background='url(https://image.flaticon.com/icons/svg/726/726210.svg)center  no-repeat';
    btn.setAttribute('disabled','disabled');
    }
</script>

{{--確認是否停止儲存 警報--}}
<script>
    function stop_info(n) {
        var content=$("#recording_table")[0].rows[n].cells;
        document.getElementById('modal-footer').innerHTML=
            "      <button type=\"button\" class=\"btn btn-secondary\" data-dismiss=\"modal\">取消</button>\n" +
            "      <button onclick=\'stop_store(\""+content[3].textContent+"\","+n+")\' " +
            "type=\"button\" class=\"btn btn-primary\" data-dismiss=\"modal\">停止儲存</button>";
        // console.log($("#recording_table")[0].rows[1].cells[1].textContent);
        document.getElementById('modal-body').innerHTML="<h1>是否要停止儲存</h1>" +
            "群組："+content[1].textContent +
            "&nbsp;頻道："+content[2].textContent +
            "&nbsp;設備編號："+content[3].textContent;
    }
</script>

{{--根據正在錄的設備編號  向後台要求完整資訊--}}
<script>
    var count=0;
    var cancel_style='  width: 35px;\n' +
        '            height: 35px;\n' +
        '            background: url(https://image.flaticon.com/icons/svg/189/189678.svg)center  no-repeat;\n' +
        '            background-size: 30px 30px;\n';
    function count_data(i) {
        if (!(count > i)){count++;}
        return count;
    }
    function get_info(cam_list) {
        for (var i in cam_list){
        $.ajax({
            type: "GET",
            url: "{{url('recordconfig/get_info')}}/"+cam_list[i],
            dataType: 'json',
            success: function(data)
            {
                count=count_data();
                if (count%2 ==0){ var clas="table-primary"}else {var clas="table-info"}
                document.getElementById('recording_info').innerHTML+="<tr class=\""+clas+"\">\n" +
                    "    <th scope=\"row\">"+count+"</th>\n" +
                    "    <td>"+data['goup_name']+"</td>\n" +
                    "    <td>"+data['camera_path']+"</td>\n" +
                    "    <td>"+data['camera_id']+"</td>\n" +
                    "    <td>"+data['camera_startime']+"</td>\n" +
                    "    <td><button id=\"cancel"+count+"\" data-toggle=\"modal\" data-target=\"#cancel_alert\"" +
                    " onclick=\'stop_info("+count+")\' class='cancle btn'style=\'"+cancel_style+"\'></button></td>\n" +
                    "</tr>";

                console.log(JSON.stringify(data));
            },
            error:function(data){
                console.log(JSON.stringify(data)+'\n'+'發生錯誤')
            }
        });
        }
    }
</script>

{{--    傳送至API 開始錄製--}}
    <script>
        $("#send").submit(function(e) {
            var form = $(this);
            var url = form.attr('action');
            $.ajax({
                type: "POST",
                url: url,
                data:form.serialize(),
                dataType: 'json',
                success: function(data)
                {
                    for (var k in data) {
                        alert('儲存成功！\n路徑：' + JSON.stringify(data[k]));
                        window.location.reload(); //重整頁面
                        // console.log(data);
                    }
                },
                error:function(data){
                    alert(JSON.stringify(data)+'\n'+'發生錯誤')
                    failure();
                }

            });
            e.preventDefault(); // avoid to execute the actual submit of the form.
        });
</script>
@endsection


