<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Support\Facades\Auth;
Route::group(['prefix'=>'/index','middleware'=>'auth'],function(){
    Route::get('/',function (){return view('index',['title'=>'歡迎使用影像調閱系統']);})->name('index');
});

Route::group(['prefix'=>'replay','middleware'=>'auth'],function(){
    Route::get('/', 'CamdbController@replay')->name('replay');
    Route::get('/select_goup/{goup_id}','CamdbController@show_in_replay');
});
Route::group(['prefix'=>'playrealtime','middleware'=>'auth'],function(){
    Route::get('/', 'CamdbController@play')->name('playrealtime');
    Route::get('/select_goup/{goup_id}','CamdbController@show_in_playrealtime');
});

Route::group(['prefix'=>'configcam','middleware'=>'auth'],function (){
    Route::get('/', 'CamdbController@config')->name('configcam');
});

Route::group(['prefix'=>'recordconfig','middleware'=>'auth'],function (){
    Route::get('/','CamdbController@record')->name('recordconfig');
    Route::get('/{cam_id}','CamdbController@find_channel');
    Route::get('/get_info/{cam_list}','CamdbController@get_info');
    Route::get('/select_goup/{goup_id}','CamdbController@show_in_recordconfig');
});


// login
Route::get('/log_in','UserController@login_index')->name('log_in');
Route::post('/login','UserController@login')->name('login');
Route::post('/logout','UserController@logout')->name('logout');


//Auth::routes();

Route::get('/home', 'HomeController@index')->name('home');

