﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Xml;

namespace ETC_App1
{
    public partial class Form2 : Form
    {
        private string Imgs_path = "";
        private string Xmls_path = "";
        private XmlLable xmlLable = new XmlLable();
        //private Form ROI { get; set; }

        public Form2()
        {
            InitializeComponent();
        }

        public Form2(string[] files) : this()
        {
            listBox1.Items.AddRange(files);
        }

        bool IsToForm1 = false;
        private void button9_Click(object sender, EventArgs e)
        {
            IsToForm1 = true;
            this.Close();
        }


        private void Form2_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (IsToForm1)
            {
                this.DialogResult = DialogResult.Yes;
            }
            else
            {
                this.DialogResult = DialogResult.No;
            }
        }

        private void img_path_btn_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog path = new FolderBrowserDialog();
            path.ShowDialog();
            Imgs_path=path.SelectedPath;

            if (!string.IsNullOrEmpty(Imgs_path)) { 
                DirectoryInfo dir = new DirectoryInfo(@Imgs_path);

                foreach (FileInfo dChild in dir.GetFiles("*.jpg"))
                {
                    this.listBox1.Items.Add("=> "+Path.Combine(Imgs_path,dChild.Name));                
                }
                foreach (FileInfo dChild in dir.GetFiles("*.png"))
                {
                    this.listBox1.Items.Add("=> " + Path.Combine(Imgs_path,dChild.Name));
                }
                if (listBox1.Items.Count > 0)
                {
                    listBox1.SetSelected(0, true);
                    string img = listBox1.SelectedItem.ToString().Remove(0,3);
                    Bitmap bitmap = new Bitmap(img);
                    pictureBox1.Image = bitmap;
                }
            }
        }
        private void xml_path_btn_Click(object sender, EventArgs e)
        {
            FolderBrowserDialog path = new FolderBrowserDialog();
            path.ShowDialog();
            Xmls_path = path.SelectedPath;
            
            XmlLableObject obj1 = new XmlLableObject("A", "11", "12", "13", "14");
            XmlLableObject obj2 = new XmlLableObject("B", "15", "16", "17", "18");
            XmlLableObject obj3 = new XmlLableObject("C", "19", "20", "21", "22");
                                    

            xmlLable.Object.Add(obj1);
            xmlLable.Object.Add(obj2);
            xmlLable.Object.Add(obj3);

            ProcessCombobox();

            CreateXmlTree(@"C:\Users\Bruce\source\repos\e-eye\ETC_App1\bin\Debug\form2_config\Eample.xml", Xmls_path+@"\Eample2.xml");
        }

        private void Form2_KeyPress(object sender, KeyPressEventArgs e)
        {
      
        }

        private void Form2_KeyDown(object sender, KeyEventArgs e)
        {
            if (e.KeyCode == Keys.D) //下一張按鈕
            {
                if (listBox1.Items.Count>0)
                {
                    if (listBox1.Items.Count > listBox1.SelectedIndex + 1)
                    {
                        listBox1.SetSelected(listBox1.SelectedIndex+1 , true);
                        string img = listBox1.SelectedItem.ToString().Remove(0, 3);
                        Bitmap bitmap = new Bitmap(img);
                        pictureBox1.Image = bitmap;

                        this.xmlLable = new XmlLable();
                        checkedListBox1.Items.Clear();

                        string xml = img.Replace(".jpg", ".xml").Replace(".png",".xml");
                        if (File.Exists(xml))
                        {
                            Console.WriteLine(xml);
                        }
                    }
                }
            }
            if (e.KeyCode == Keys.A) //上一張按鈕
            {
                if (listBox1.Items.Count > 0)
                {
                    if (0 <= listBox1.SelectedIndex -1)
                    {
                        listBox1.SetSelected(listBox1.SelectedIndex - 1, true);
                        string img = listBox1.SelectedItem.ToString().Remove(0, 3);
                        Bitmap bitmap = new Bitmap(img);
                        pictureBox1.Image = bitmap;
                        this.xmlLable = new XmlLable();
                        checkedListBox1.Items.Clear();
                    }
                }
            }
            if (e.Control && e.KeyCode == Keys.S) //儲存按鈕
            {

            }
            if (e.Control && e.KeyCode == Keys.W) //創建區塊 按鈕
            {
                Point pp = new Point(300, 300);
                Size ss = new Size(50, 50);
                BndBox box = new BndBox(pp,ss);
                Controls.Add(box);
                box.Parent = pictureBox1;
                box.Refresh();
                box.Show();
                box.BringToFront();
            }
            if (e.Control && e.KeyCode == Keys.E) //儲存按鈕
            {

            }
        }
        public void CreateXmlTree(string src_path,string save_path)
        {
            XmlDocument doc = new XmlDocument();
            doc.Load(src_path);

            List<XmlLableObject>obj = xmlLable.Object;
            XmlNode newobj;
            for (int i = 0; i < obj.Count; i++)
            {
                if (i != 0)
                {
                    newobj = doc.ImportNode(doc.DocumentElement.SelectSingleNode("object"), true);
                    doc.DocumentElement.AppendChild(newobj);
                }
                else
                    newobj = doc.DocumentElement.SelectSingleNode("object");

                XmlNode name_node = newobj.SelectSingleNode("name");
                if (name_node.LastChild == null)
                    name_node.AppendChild(doc.CreateTextNode(obj[i].Name));
                else
                    name_node.ReplaceChild(doc.CreateTextNode(obj[i].Name), name_node.LastChild);// 修改節點

                
                XmlNode x1_node = newobj.SelectSingleNode("bndbox").SelectSingleNode("xmin");
                if (x1_node.LastChild == null)
                    x1_node.AppendChild(doc.CreateTextNode(obj[i].X1));
                else
                    x1_node.ReplaceChild(doc.CreateTextNode(obj[i].X1), x1_node.LastChild);// 修改節點


                XmlNode y1_node = newobj.SelectSingleNode("bndbox").SelectSingleNode("ymin");
                if(y1_node.LastChild==null)
                    y1_node.AppendChild(doc.CreateTextNode(obj[i].Y1));
                else
                    y1_node.ReplaceChild(doc.CreateTextNode(obj[i].Y1), y1_node.LastChild);// 修改節點

                XmlNode x2_node = newobj.SelectSingleNode("bndbox").SelectSingleNode("xmax");
                if (x2_node.LastChild == null)
                    x2_node.AppendChild(doc.CreateTextNode(obj[i].X2));
                else
                    x2_node.ReplaceChild(doc.CreateTextNode(obj[i].X2), x2_node.LastChild);// 修改節點

                XmlNode y2_node = newobj.SelectSingleNode("bndbox").SelectSingleNode("ymax");
                if(y2_node.LastChild == null)
                    y2_node.AppendChild(doc.CreateTextNode(obj[i].Y2));
                else
                    y2_node.ReplaceChild(doc.CreateTextNode(obj[i].Y2), y2_node.LastChild);// 修改節點
            }
            doc.Save(save_path);
        }
        public void ProcessCombobox()
        {
            List<XmlLableObject> objs = xmlLable.Object;

            foreach (XmlLableObject obj in objs)
            {
                string temp = String.Format("{0}: {1},{2},{3},{4}", obj.Name, obj.X1, obj.Y1, obj.X2, obj.Y2);

                if (checkedListBox1.Items.IndexOf(temp) < 0 || true)
                {
                    checkedListBox1.Items.Add(temp);
                    checkedListBox1.SetItemChecked(checkedListBox1.Items.IndexOf(temp), true);
                }
            }
        }

        
    
    }
}
