﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using NHPB;

namespace NHPB_App1
{
    class Program
    {
        private static List<string> extensions = new List<string>() { ".jpg", ".jpeg" };

        static void Main(string[] args)
        {
            //args = new string[] { @"C:\Users\SHUO-CHEN\Desktop\test" };

            if (args != null && args.Length > 0)
            {
                Dictionary<string, List<string>> images = new Dictionary<string, List<string>>();

                string root = args[0] + "-0";

                Directory.Move(args[0], root);

                Console.Write("影像分組中...");

                foreach (string f in Directory.GetFiles(root))
                {
                    if (extensions.Contains(Path.GetExtension(f)))
                    {
                        string[] s = Path.GetFileNameWithoutExtension(f).Split('_');

                        string key = s[0] + Path.GetExtension(f);

                        if (!images.ContainsKey(key))
                        {
                            images.Add(key, new List<string>());
                        }

                        images[key].Add(f);
                    }
                }

                Console.WriteLine("完成，共 " + images.Count + " 組影像。");

                foreach (string key in images.Keys)
                {
                    string filename = Directory.CreateDirectory(args[0] + Path.DirectorySeparatorChar).FullName + key;

                    if (images[key].Count > 1)
                    {
                        Bitmap image = ImageList.Combine(images[key].ToArray());

                        image.Save(filename);

                        Console.WriteLine("檢查到 " + images[key].Count + " 張影像，合併於 " + filename);
                    }
                    else
                    {
                        File.Copy(images[key][0], filename);

                        Console.WriteLine("檢查到 " + images[key].Count + " 張影像，儲存於 " + filename);
                    }
                }

                Directory.Move(root, args[0] + "-" + images.Count);

                Console.Write("處理完畢，請按任意鍵退出...");
            }
            else { Console.Write("請將處理資料夾拖移至程序圖示上方執行..."); }

            Console.ReadKey();
        }
    }
}
