﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Drawing.Imaging;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace NHPB_App2
{
    class Program
    {
        static void Main(string[] args)
        {
            //args = new string[] { @"\\192.168.6.74\國道\P類\13P8050802\Photos" };

            for (int i = 0; i < args.Length; i++)
            {
                if (Directory.Exists(args[i]) == true)
                {
                    Directory.Move(args[i], args[i] + " (原始照片)");

                    Directory.CreateDirectory(args[i]);

                    foreach (string f in Directory.GetFiles(args[i] + " (原始照片)"))
                    {
                        Console.Write("讀取檔案：" + f);

                        Bitmap b = new Bitmap(f);

                        Graphics g = Graphics.FromImage(b);

                        Font font = new Font(FontFamily.GenericMonospace, b.Size.Height / 20, FontStyle.Bold, GraphicsUnit.Pixel);

                        Brush brush = Brushes.Red;

                        Point point = new Point(b.Size.Width - 10 * b.Size.Height / 20, b.Size.Height - b.Size.Height / 20);

                        string path = args[i] + Path.DirectorySeparatorChar + Path.GetFileName(f);

                        string[] s = Path.GetFileNameWithoutExtension(f).Split('.');

                        string y = int.TryParse(s[1].Substring(0, 3), out int result) ? Convert.ToString(result + 1911) : "0000";

                        string md = s[1].Substring(3, 2) + "/" + s[1].Substring(5, 2);

                        string hm = s[2].Substring(0, 2) + ":" + s[2].Substring(2, 2);

                        Console.Write(" -> 附加文字：" + y + "/" + md + " " + hm);

                        g.DrawString(y + "/" + md + " " + hm, font, brush, point);

                        g.Save();

                        Console.Write(" -> 儲存中");

                        b.Save(path, ImageFormat.Jpeg);

                        Console.WriteLine(" -> 儲存完成");
                    }
                }
            }
        }
    }
}
