﻿using System;
using System.Collections.Generic;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;
using System.Drawing;

namespace ETC_App1
{
    public class BndBox : Panel
    {
        int dotSize = 10;  //需要被 2 整除
        List <Color> colors=new List<Color> { Color.Red,Color.Orange,Color.Yellow,Color.Green,Color.Blue,Color.Brown,Color.Purple};
        int Color_ind;
        public int Num;
        public BndBox(Point location, Size size , int color)
        {
            InitializeComponent();
            this.DoubleBuffered = true;
            this.Location = location;
            this.Size = size;
            this.Num = color;
            if (colors.Count <= color)
            {
                Random rnd = new Random();
                colors.Add(Color.FromArgb(255, rnd.Next(100, 255), rnd.Next(100, 255), rnd.Next(100, 255)));
                this.Color_ind = 7;
            }
            else
                this.Color_ind = color;
        }

        private void panel1_Paint(object sender, PaintEventArgs e)
        {
            Panel pl = (Panel)sender;

            e.Graphics.DrawRectangle(new Pen(colors[Color_ind], 2), dotSize / 2, dotSize / 2, pl.Width - dotSize, pl.Height - dotSize);

            Point x1 = new Point(0, 0);
            Point y1 = new Point(0, pl.Height);
            Point x2 = new Point(pl.Width, 0);
            Point y2 = new Point(pl.Width, pl.Height);

            Rectangle rect = new Rectangle(0, 0, dotSize, dotSize);
            Rectangle rect2 = new Rectangle(0, pl.Height - dotSize, dotSize, dotSize);
            Rectangle rect3 = new Rectangle(pl.Width - dotSize, 0, dotSize, dotSize);
            Rectangle rect4 = new Rectangle(pl.Width - dotSize, pl.Height - dotSize, dotSize, dotSize);

            e.Graphics.FillRectangle(new SolidBrush(Color.GreenYellow), rect);
            e.Graphics.FillRectangle(new SolidBrush(Color.GreenYellow), rect2);
            e.Graphics.FillRectangle(new SolidBrush(Color.GreenYellow), rect3);
            e.Graphics.FillRectangle(new SolidBrush(Color.GreenYellow), rect4);
        }

        private Point MouseDownLocation;

        private void panel1_MouseDown(object sender, MouseEventArgs e)
        {
            if (e.Button == System.Windows.Forms.MouseButtons.Left)
            {
                MouseDownLocation = e.Location;
            }
        }
        private void panel1_MouseMove(object sender, MouseEventArgs e)
        {
            if (e.Button == System.Windows.Forms.MouseButtons.Left)
            {
                if (MouseDownLocation.X <= dotSize && MouseDownLocation.Y <= dotSize && this.Width >= dotSize * 3 && this.Height >= dotSize * 3) //左上點
                {
                    this.Left += e.X - MouseDownLocation.X;
                    this.Top += e.Y - MouseDownLocation.Y;
                    this.Width -= e.X - MouseDownLocation.X;
                    this.Height -= e.Y - MouseDownLocation.Y;
                }
                else if (MouseDownLocation.X <= dotSize && MouseDownLocation.Y >= this.Height - dotSize && this.Width >= dotSize * 3 && this.Height >= dotSize * 3) //左下點
                {
                    this.Left += e.X - MouseDownLocation.X;
                    this.Width -= e.X - MouseDownLocation.X;
                    this.Height += e.Y - MouseDownLocation.Y;
                    MouseDownLocation.Y = e.Y;

                }
                else if (MouseDownLocation.X >= this.Width - dotSize && MouseDownLocation.Y <= dotSize && this.Width >= dotSize * 3 && this.Height >= dotSize * 3) //右上點
                {
                    this.Top += e.Y - MouseDownLocation.Y;
                    this.Width += e.X - MouseDownLocation.X;
                    this.Height -= e.Y - MouseDownLocation.Y;

                    MouseDownLocation.X = e.X;
                }
                else if (MouseDownLocation.X >= this.Width - dotSize && MouseDownLocation.Y >= this.Height - dotSize && this.Width >= dotSize * 3 && this.Height >= dotSize * 3) //右下點
                {
                    this.Width += e.X - MouseDownLocation.X;
                    this.Height += e.Y - MouseDownLocation.Y;

                    MouseDownLocation.X = e.X;
                    MouseDownLocation.Y = e.Y;
                    this.Left += 1;
                    this.Left -= 1;
                }
                else if (this.Width >= dotSize * 3 && this.Height >= dotSize * 3)
                {
                    this.Left = e.X + this.Left - MouseDownLocation.X;
                    this.Top = e.Y + this.Top - MouseDownLocation.Y;
                }
                else
                {
                    this.Width += 1;
                    this.Height += 1;
                }
                if (this.Top < 0)
                    this.Top = 0;
                if (this.Left < 0)
                    this.Left = 0;
                PictureBox perent = this.Parent as PictureBox;
                if (perent.Height < this.Top + this.Height)
                    this.Top = perent.Height - this.Height;
                if (perent.Width < this.Left + this.Width)
                    this.Left = perent.Width - this.Width;
            }
        }

        private void InitializeComponent()
        {
            this.SuspendLayout();
            // 
            // BndBox
            // 
            this.BackColor = System.Drawing.Color.Transparent;
            this.Paint += new System.Windows.Forms.PaintEventHandler(this.panel1_Paint);
            this.MouseClick += new System.Windows.Forms.MouseEventHandler(this.BndBox_MouseClick);
            this.MouseDown += new System.Windows.Forms.MouseEventHandler(this.panel1_MouseDown);
            this.MouseMove += new System.Windows.Forms.MouseEventHandler(this.panel1_MouseMove);
            this.ResumeLayout(false);

        }

        private void BndBox_MouseClick(object sender, MouseEventArgs e)
        {
            this.BringToFront();
        }
    }
}
