﻿using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ETC_App1
{
    public partial class Form3 : Form
    {
        public Form3()
        { 
            InitializeComponent();         
            this.StartPosition = FormStartPosition.Manual;
            this.ControlBox = false;


            listBox1.Items.Add("plate");
            for (int j = 0; j <= 9; j++)
            {
                listBox1.Items.Add(j.ToString());
            }

            for (int i = 65; i<= 90;i++)
            {
                listBox1.Items.Add(((Keys)i).ToString());
            }
        }
        public Form3(bool fastkey,string name="") : this()
        {
            textBox1.Text = name;
            checkBox1.Checked = fastkey;
        }

        bool IsToForm2 = false;
        public string Label;
        public bool fastkey;

        private void Form3_FormClosing(object sender, FormClosingEventArgs e)
        {
            if (IsToForm2)
            {
                this.DialogResult = DialogResult.Yes;
            }
            else
            {
                this.DialogResult = DialogResult.No;
            }
        }

        private void OK_btn_Click(object sender, EventArgs e)
        {            
            if (String.IsNullOrEmpty(textBox1.Text.Replace(" ","")))
            {
                MessageBox.Show("請輸入標籤", "系統提示", MessageBoxButtons.OK);
            }
            else
            {
                Label = textBox1.Text.Replace(" ","");
                IsToForm2 = true;
                this.Close();
            }            
        }

        private void Cancel_btn_Click(object sender, EventArgs e)
        {
            IsToForm2 = true;
            this.Close();
        }

        private void listBox1_SelectedValueChanged(object sender, EventArgs e)
        {
            textBox1.Text=listBox1.SelectedItem.ToString();
        }

        private void checkBox1_CheckedChanged(object sender, EventArgs e)
        {
            fastkey = checkBox1.Checked;
            if (checkBox1.Checked)
            {
                listBox1.Enabled = false;
                textBox1.Enabled = false;
                //OK_btn.Enabled = false;
                textBox1.TextChanged += textBox1_TextChanged;
            }
            else
            {
                listBox1.Enabled = true;
                textBox1.Enabled = true;
                //OK_btn.Enabled = true;
                textBox1.TextChanged -= textBox1_TextChanged;
            }
        }

        private void Form3_KeyDown(object sender, KeyEventArgs e)
        {
            if (!textBox1.Focus())
            {
                if (e.KeyValue >= 65 && e.KeyValue <= 90) // A~Z
                {
                    textBox1.Text = e.KeyCode.ToString();
                }
                if (e.KeyValue >= 48 && e.KeyValue <= 57) // 0~9
                {
                    textBox1.Text = e.KeyCode.ToString().Replace("NumPad", "").Replace("D", "");
                }
                if (e.KeyValue >= 96 && e.KeyValue <= 105) // 0~9
                {
                    textBox1.Text = e.KeyCode.ToString().Replace("NumPad", "").Replace("D", "");
                }
            }     
        }

        private void textBox1_TextChanged(object sender, EventArgs e)
        {            
            OK_btn.PerformClick();
        }
    }
}
