import  time,os,signal
import subprocess as sp
from influxdb import InfluxDBClient
import datetime
import psutil
import pytz
from datetime import timedelta



rtspUrl='rtsp://192.168.5.208/{0}'.format(os.getenv('goup_name')+"/"+os.getenv('camera_path'))
client = InfluxDBClient('192.168.0.6', 8086, 'root', 'root','stream')

client.create_database('stream')

def switch(startDay,rtspUrl):
    command = 'ffmpeg -fflags nobuffer -rtsp_transport tcp -i {1} -vsync 0 -copyts -c:v copy -movflags frag_keyframe+empty_moov -an  -f segment -strftime 1 -segment_list_flags live -segment_time 10 -segment_list_size 0 -segment_format mpegts -segment_list /data/{0}/{2}/index.m3u8 -segment_list_type m3u8 -segment_list_entry_prefix /record/{0}/{2}/  /data/{0}/{2}/%s.ts'.format(startDay,rtspUrl,(os.getenv('goup_name')+"/"+os.getenv('camera_path')))
    return command
tz=pytz.timezone('Asia/Taipei')
startDay=datetime.datetime.now(tz).date()


def mkdir(path):
    #引入模組

    #去除首位空格
    path=path.strip()
    #去除尾部 \ 符號
    path=path.rstrip("\\")

    #判斷路徑是否存在
    #存在True
    #不存在False
    isExists=os.path.exists(path)

    #判斷結果
    if not isExists:
    #如果不存在則建立目錄
    #建立目錄操作函式
        os.makedirs(path)

        print (path+'success')
        return True
    else:
# 如果目錄存在則不建立，並提示目錄已存在
        print (path+'Directory already exists')
        return False


# In[6]:


def read_data():
    global lines
    global timestamp
    global result
    global EXTINF
    start=lines
    try:
        time.sleep(5)
        with open(('/data/{0}/{1}/index.m3u8').format(startDay,(os.getenv('goup_name')+"/"+os.getenv('camera_path')))) as f:
            data=f.readlines()
            for l in range(start,len(data),1):            #依次讀取每行
                line=data[l].strip()                      #去掉每行頭尾空白
                lines+=1
                print('==========',l)


                if line.startswith('#EXTINF'):       #判斷是否是空行或註解
                    EXTINF.append(line)
                    print(EXTINF)
                    continue                                    #是的話，跳過不處理

                elif line.startswith('#EXT-X-ENDLIST'):
                    continue

                else:
                    timestamp=line.split(('/record/{0}/{1}/').format(startDay,(os.getenv('goup_name')+"/"+os.getenv('camera_path'))))[1].split('.ts')[0]
                    timestamp_data=int(timestamp)
                    result.append(timestamp_data)
                    print(result)

                    json_body = [
                        {
                            "measurement": os.getenv('goup_name'),
                            "tags":{
                                "host": "RD",
                                "ch": os.getenv('camera_path'),
                            },
                            "fields":{
                                "save_path":mkpath,
                                "timestamp_data":result.pop(0),
                                "EXTINF":EXTINF.pop(0),
                            }
                        }
                    ]
                    client.write_points(json_body)

                    print(json_body)

                    print('success update to influxdb')

                    client.close()

    except IOError as e:
        print(e)


# In[7]:
mkpath="/data/{0}/{1}/".format(startDay,(os.getenv('goup_name')+"/"+os.getenv('camera_path')))
# 呼叫函式
mkdir(mkpath)
lines=5
temp=''
timestamp=''
result = list()
EXTINF = list()
cp =None
while True:
    if (cp!=None and status==None):
        read_data()
        cp.poll()
        status=cp.returncode
        if (startDay!= datetime.datetime.now(tz).date()):
            startDay=datetime.datetime.now(tz).date()

            command=switch(startDay,rtspUrl)
            pp=sp.Popen(command,shell=True)
            lines=5
            mkpath="/data/{0}/{1}/".format(startDay,(os.getenv('goup_name')+"/"+os.getenv('camera_path')))
            mkdir(mkpath)
            try:
                #psutil.Process(cp.pid)
                #cp.terminate() #or
                #cp.kill()
                os.kill(cp.pid+1,signal.SIGTERM)
                time.sleep(1)
                cp=pp
                time.sleep(1)
                cp.poll()
                status=cp.returncode
            except psutil.NoSuchProcess as e:
                print(e)
    else:
        filepath ="/data/{0}/{1}/index.m3u8".format(startDay,(os.getenv('goup_name')+"/"+os.getenv('camera_path')))
        m3u8_isExists=os.path.isfile(filepath)
        if m3u8_isExists:
            os.remove("/data/{0}/{1}/index.m3u8".format(startDay,(os.getenv('goup_name')+"/"+os.getenv('camera_path'))))
        lines=5
        command=switch(startDay,rtspUrl)
        cp=sp.Popen(command,shell=True)
        time.sleep(1)
        cp.poll()
        status=cp.returncode

