import os,time,sys
import shutil
import stat

def dir_status():
    line=[]
    with os.scandir('/data') as entries:
        for entry in entries:

            dir_stat=entry.stat().st_mtime,entry.name
            line.append(dir_stat)
            line.sort()

        c=line.pop(0)

        return(c[1])

def copytree(src='/data/{0}'.format(dir_status()), dst='/nas/{0}'.format(dir_status()), symlinks = False, ignore = None):

    if not os.path.exists(dst):
        os.makedirs(dst)
        shutil.copystat(src, dst)
    lst = os.listdir(src)
    if ignore:
        excl = ignore(src, lst)
        lst = [x for x in lst if x not in excl]
    for item in lst:
        s = os.path.join(src, item)
        d = os.path.join(dst, item)
        if symlinks and os.path.islink(s):
            if os.path.lexists(d):
                os.remove(d)
                os.symlink(os.readlink(s), d)
            try:
                st = os.lstat(s)
                mode = stat.S_IMODE(st.st_mode)
                os.lchmod(d, mode)
            except:
                pass
        elif os.path.isdir(s):
            copytree(s, d, symlinks, ignore)
        else:
            shutil.copy2(s, d)
def disk_root():
    s=0
    disk=os.statvfs('/data')
    percent=(disk.f_blocks-disk.f_bfree)*100/(disk.f_blocks-disk.f_bfree+disk.f_bavail)
    if percent > 50:
        return s==0
    else:
        return s==1
def restart_program():
    python = sys.executable
    os.execl(python, python, * sys.argv)

while True:
    time.sleep(10)
    if  disk_root() == True :
        try:
            copytree()
        except IOError as e:
            print("Unable to copy file. %s" % e)
        except:
            print("ERROR")
        else:
            old_path = r"/data/{0}".format(dir_status())

            try:
                shutil.rmtree(old_path)
            except OSError as e:
                print(e)
            else:
                print("The directory is deleted successfully")
            print("program restart !! ")
            time.sleep(3)
            restart_program()
