#!/usr/bin/env python
# coding: utf-8

import os,time
#import subprocess as sp
from influxdb import InfluxDBClient

client = InfluxDBClient('192.168.0.6', 8086, 'root', 'root', 'stream')


fields = """timestamp,save_path,EXTINF"""
measurement = """{}""".format(os.getenv('goup_name'))
filters = """ WHERE time >='{0}'-8h and time <='{1}'-8h """.format(os.getenv('START_DATE'),os.getenv('END_DATE'))
GROUP="""GROUP BY {} """.format("ch")
query = """SELECT {} FROM {} {} {} tz('Asia/Taipei')""".format(fields, measurement, filters,GROUP)
print("Performing a query: {}".format(query))
results= client.query(query)



# 1563984000000ms
#results=client.query('select "timestamp" ,"save_path","EXTINF" FROM "stream"."autogen"."{2}" WHERE  time >= {0}ms and time <= {1}ms GROUP BY "ch"'.format(os.getenv('START'),os.getenv('END'),os.getenv('goup_name')))


#results.raw

path="/data/replay/{0}/{1}".format(os.getenv('goup_name'),os.getenv('camera_path'))
isExists=os.path.exists(path)
if not isExists:
    os.makedirs(path)

points = list(results.get_points(measurement=os.getenv('goup_name'),tags={'ch':os.getenv('camera_path')}))


for point in points:
    m3u8=point['save_path']+point['timestamp']+'.ts'
    save_path=point['save_path']
    EXTINF=point['EXTINF']
    print(m3u8)

def read_data():
    start=5
    with open("/data/replay/{0}/{1}/replay.m3u8".format(os.getenv('goup_name'),os.getenv('camera_path')), 'w') as f:

        try:
            data=open("/data/replay/{0}/{1}/replay.m3u8".format(os.getenv('goup_name'),os.getenv('camera_path'))).read()
            lines=[]
            if (len(data) ==0):
                lines.append("#EXTM3U\n")
                lines.append("#EXT-X-VERSION:3\n")
                lines.append("#EXT-X-MEDIA-SEQUENCE:0\n")
                lines.append("#EXT-X-ALLOW-CACHE:NO\n")
                lines.append("#EXT-X-TARGETDURATION:11\n")

            for l in range(start,len(points),1):  #依次讀取每行
                if (points[l]['EXTINF']):
                    lines.append(points[l]['EXTINF'] + "\n")
                    lines.append("/record/"+(points[l]['save_path']+points[l]['timestamp']).split('/data/')[1]+".ts" +"\n")

        finally:
            lines.append("#EXT-X-ENDLIST")
            f.writelines(lines)
            f.flush()
            #f.close()

read_data()


#def replay():
    #cmd=' ffmpeg  -re -i /ISRG106/replay/{0}/replay.m3u8   -c:v copy -an -rtsp_transport tcp -f rtsp  rtsp://{1}:{2}/replay/{0}'.format(os.getenv('goup_name')+"/"+os.getenv('camera_path'),os.getenv('ezd_ip'),os.getenv('ezd_port'))
    #return cmd



#cmd=replay()
#p1=sp.Popen(cmd,shell=True)


#p1.communicate()

