from flask import request, jsonify
from flask_restful import Resource, reqparse
from influxdb import InfluxDBClient
import pytz
import docker,os,time
import Sqldb as sql
import DockerAPI as dapi
import timestamp_form as stamp
from datetime import datetime
influxclient = InfluxDBClient('192.168.0.6', 8086, 'root', 'root', 'stream')


def read_data(name, path, points,date):
    start=5
    m3u8_path = "/data/{0}".format(date)
    wgs_path = "/wgs/{0}".format(date)
    
    if(name=="wgs"):
        with open("/wgs/replay/{0}/{1}/replay.m3u8".format(name,path), 'w') as f:
            if os.path.isdir(wgs_path):
                try:
                    data=open("/wgs/replay/{0}/{1}/replay.m3u8".format(name,path)).read()
                    lines=[]
                    if (len(data) ==0):
                        lines.append("#EXTM3U\n")
                        lines.append("#EXT-X-VERSION:3\n")
                        lines.append("#EXT-X-MEDIA-SEQUENCE:0\n")
                        lines.append("#EXT-X-ALLOW-CACHE:NO\n")
                        lines.append("#EXT-X-TARGETDURATION:11\n")

                    for l in range(start,len(points),1):  #依次讀取每行
                        if (points[l]['EXTINF']):

                            #if os.path.isfile((points[l]['save_path']+points[l]['timestamp']).split('/data/')[1]+".ts"):
                            a1 = int(points[l - 1]['timestamp_data'])

                            a2 = int(points[l]['timestamp_data'])

                            a3 = int(points[l]['EXTINF'].split('#EXTINF:')[1].split(',')[0].split('.')[0])

                            if ((a2 - a1) > a3 +1):
                                lines.append("#EXT-X-DISCONTINUITY\n")

                            lines.append(points[l]['EXTINF'] + "\n")
                            lines.append("/record/"+(points[l]['save_path']+str(points[l]['timestamp_data'])).split('/{}/'.format(name),1)[1]+".ts"+"\n")
                finally:
                    lines.append("#EXT-X-ENDLIST")
                    f.writelines(lines)
                    f.flush()
                    #f.close()
            else:    
                try:
                    data=open("/wgs/replay/{0}/{1}/replay.m3u8".format(name,path)).read()
                    lines=[]
                    if (len(data) ==0):
                        lines.append("#EXTM3U\n")
                        lines.append("#EXT-X-VERSION:3\n")
                        lines.append("#EXT-X-MEDIA-SEQUENCE:0\n")
                        lines.append("#EXT-X-ALLOW-CACHE:NO\n")
                        lines.append("#EXT-X-TARGETDURATION:11\n")

                    for l in range(start,len(points),1):  #依次讀取每行
                        if (points[l]['EXTINF']):

                            #if os.path.isfile((points[l]['save_path']+points[l]['timestamp']).split('/data/')[1]+".ts"):
                            a1 = int(points[l - 1]['timestamp_data'])

                            a2 = int(points[l]['timestamp_data'])

                            a3 = int(points[l]['EXTINF'].split('#EXTINF:')[1].split(',')[0].split('.')[0])

                            if ((a2 - a1) > a3 +1):  
                                lines.append("#EXT-X-DISCONTINUITY\n")

                            lines.append(points[l]['EXTINF'] + "\n")
                            if points[l]['save_path'].split('/wgs/')[1] != date and os.path.isdir(points[l]['save_path']):
                                lines.append("/record/"+(points[l]['save_path']+str(points[l]['timestamp_data'])).split('/{}/'.format(name),1)[1]+".ts"+"\n")
                            else:
                                lines.append("/record/nas/"+(points[l]['save_path']+str(points[l]['timestamp_data'])).split('/{}/'.format(name),1)[1]+".ts"+"\n")
                finally:
                    lines.append("#EXT-X-ENDLIST")
                    f.writelines(lines)
                    f.flush()
                    #f.close()
    
    else:
        with open("/data/replay/{0}/{1}/replay.m3u8".format(name,path), 'w') as f:
            if os.path.isdir(m3u8_path):
                try:
                    data=open("/data/replay/{0}/{1}/replay.m3u8".format(name,path)).read()
                    lines=[]
                    if (len(data) ==0):
                        lines.append("#EXTM3U\n")
                        lines.append("#EXT-X-VERSION:3\n")
                        lines.append("#EXT-X-MEDIA-SEQUENCE:0\n")
                        lines.append("#EXT-X-ALLOW-CACHE:NO\n")
                        lines.append("#EXT-X-TARGETDURATION:11\n")

                    for l in range(start,len(points),1):  #依次讀取每行
                        if (points[l]['EXTINF']):

                            #if os.path.isfile((points[l]['save_path']+points[l]['timestamp']).split('/data/')[1]+".ts"):
                            a1 = int(points[l - 1]['timestamp_data'])

                            a2 = int(points[l]['timestamp_data'])

                            a3 = int(points[l]['EXTINF'].split('#EXTINF:')[1].split(',')[0].split('.')[0])

                            if ((a2 - a1) > a3 +1):
                                lines.append("#EXT-X-DISCONTINUITY\n")

                            lines.append(points[l]['EXTINF'] + "\n")
                            lines.append("/record/"+(points[l]['save_path']+str(points[l]['timestamp_data'])).split('/data/')[1]+".ts"+"\n")
                finally:
                    lines.append("#EXT-X-ENDLIST")
                    f.writelines(lines)
                    f.flush()
                    #f.close()

            else:
                
                try:
                    data=open("/data/replay/{0}/{1}/replay.m3u8".format(name,path)).read()
                    lines=[]
                    if (len(data) ==0):
                        lines.append("#EXTM3U\n")
                        lines.append("#EXT-X-VERSION:3\n")
                        lines.append("#EXT-X-MEDIA-SEQUENCE:0\n")
                        lines.append("#EXT-X-ALLOW-CACHE:NO\n")
                        lines.append("#EXT-X-TARGETDURATION:11\n")
                        
                    for l in range(start,len(points),1):  #依次讀取每行
                        
                        if (points[l]['EXTINF']):
                            #if os.path.isfile((points[l]['save_path']+points[l]['timestamp']).split('/data/')[1]+".ts"):
                            a1 = int(points[l - 1]['timestamp_data'])

                            a2 = int(points[l]['timestamp_data'])

                            a3 = int(points[l]['EXTINF'].split('#EXTINF:')[1].split(',')[0].split('.')[0])

                            if ((a2 - a1) > a3 +1):
                                lines.append("#EXT-X-DISCONTINUITY\n")

                            lines.append(points[l]['EXTINF'] + "\n")
                            

                            if points[l]['save_path'].split('/{0}'.format(name))[0].split('/data/')[1] != date and os.path.isdir(points[l]['save_path']):
                                lines.append("/record/"+(points[l]['save_path']+str(points[l]['timestamp_data'])).split('/data/')[1]+".ts"+"\n")
                            else:

                                lines.append("/record/nas/"+(points[l]['save_path']+str(points[l]['timestamp_data'])).split('/data/')[1]+".ts"+"\n")

                finally:
                    lines.append("#EXT-X-ENDLIST")
                    f.writelines(lines)
                    f.flush()
                    #f.close()            
class Replay2(Resource):
    def __init__(self):
        self.reqparse = reqparse.RequestParser()
        self.reqparse.add_argument('start_time',required=True,help="start time interval")
        self.reqparse.add_argument('end_time',required=True,help="end time interval")
        self.reqparse.add_argument('cam_ids',required=True,help="required camera_path")
        self.reqparse.add_argument('goup_name',required=True,help="required goup_name")
    
    def get(self):
        arg=self.reqparse.parse_args()
        return arg
    def post(self):
        arg=self.reqparse.parse_args()
        
        #stime=stamp.trans(arg['start_time'])
        #etime=stamp.trans(arg['end_time'])
       
        goup_name=arg['goup_name']
        cam_ids=arg['cam_ids'].split(',')
        
        #client=docker.from_env()
        camera_path=sql.select_cam_path(cam_ids)
        #temp
        #fps = 10
        #ip = '192.168.5.217'
        #port = 554
        
        stream=[]
        
        
        
        for i in range(len(camera_path)):
            if goup_name=='wgs':
                path="/wgs/replay/{0}/{1}".format(goup_name,camera_path[i])
            else:    
                path="/data/replay/{0}/{1}".format(goup_name,camera_path[i])
            isExists=os.path.exists(path)
            if not isExists:
                os.makedirs(path)
            syear,smonth,sday,sh,sm,ss=stamp.ddate(arg['start_time'])
            
            eyear,emonth,eday,eh,em,es=stamp.ddate(arg['end_time'])
            
            DATE ='%s-%s-%s'% (syear,smonth,sday)
            
            start_timestamp=stamp.trans(arg['start_time'])
            end_timestamp=stamp.trans(arg['end_time'])
            
            fields = """timestamp_data,save_path,EXTINF"""
            measurement = """{}""".format(goup_name)
            filters = """ WHERE  timestamp_data >= {0} and timestamp_data <= {1}""".format(start_timestamp,end_timestamp)
            GROUP="""GROUP BY {} """.format("ch")
            query = """SELECT {} FROM {} {} {} """.format(fields, measurement, filters,GROUP)
            #print("Performing a query: {}".format(query))
            results= influxclient.query(query)
                
            points=list(results.get_points(measurement=goup_name,tags={'ch':camera_path[i]}))
            
            print(len(points))
            
            read_data(goup_name, camera_path[i], points,DATE)
            if goup_name=='wgs' :
                stream.append("http://192.168.5.217:10007/record/replay/%s/%s/replay.m3u8" % (goup_name,camera_path[i]))
            else:
                stream.append("http://192.168.5.217:10008/record/replay/%s/%s/replay.m3u8" % (goup_name,camera_path[i]))
        return stream

    

            
    
class Transfer(Resource):
    def __init__(self):
        self.reqparse = reqparse.RequestParser()
        self.reqparse.add_argument('cam_ids',required=True,help="required cam_id")
        self.reqparse.add_argument('goup_name',required=True,help="required goup_name")        
 
        
    def get(self):
        arg=self.reqparse.parse_args()
        return arg
    def post(self):
        arg=self.reqparse.parse_args()
        
        cam_ids=arg['cam_ids']   #記得加逗號!!  ex. DVR0001,
        goup_name=arg['goup_name']
        cam_id,cam_type,cam_host,cam_port,cam_user,cam_pswd,cam_path=sql.select_cam(cam_ids)

        
        
        #client=docker.from_env()
        
        stream=[]
        #client.images.build(path="./transfer",tag="transfer")
        
        #run_list=dapi.check_trans_container()
        tz=pytz.timezone('Asia/Taipei')
        now=datetime.now(tz).date()
        for i in range(len(cam_id)):
           # env = []
            #env.append('camera_id=%s' % (cam_id[i]))
            #env.append('goup_name=%s' % (goup_name))
           # env.append('type_id=%s' % (cam_type[i])) 
           # env.append('camera_host=%s' % (cam_host[i])) 
#             env.append('cam_port=%s' % (cam_port[i]))
#             env.append('camera_user=%s' % (cam_user[i]))
#             env.append('camera_pswd=%s' % (cam_pswd[i]))
#             env.append('camera_path=%s' % (cam_path[i]))
#             env.append('srs_ip=%s' % (srs_ip))
#             env.append('srs_port=%s' % (srs_port))       
            
            #bind = '/stream/{0}-{1}-{2}/{3}/{4}'.format(y, m, d, dvr, channel[i])
#             bind= '/ISRG106'
#             vol = {}
#             vol[bind] = {'bind': bind, 'mode': 'rw'}
#             container=client.containers.run("replay:latest",environment=env,network='dvr_lan',volumes=vol,detach=True)
            #try:
                #run_list.index(cam_id[i])                
            #except:
                #container=client.containers.run("transfer:latest",environment=env,network='dvr_lan',name='transfer_%s'% cam_id[i],detach=True)
            if goup_name=='wgs' :
                stream.append("http://192.168.5.217:10007/record/%s/%s/%s/index.m3u8" % (now,goup_name,cam_path[i]))
            else:    
                stream.append("http://192.168.5.217:10008/record/%s/%s/%s/index.m3u8" % (now,goup_name,cam_path[i]))
        return stream