﻿//using PeerSDK.Wrapper;
//using Newtonsoft.Json;
//using System;
//using System.Collections.Generic;
//using System.Drawing;
//using System.Drawing.Drawing2D;
//using System.Drawing.Imaging;
//using System.Diagnostics;
//using System.IO;
//using System.Linq;
//using System.Text;
//using System.Threading.Tasks;

//namespace DVRModel
//{
//    public class DVR
//    {
//        private Dictionary<int, DVRChannel> dict = new Dictionary<int, DVRChannel>();

//        private string filename = "data" + Path.DirectorySeparatorChar;  // 影像儲存路徑，data\

//        public string Host { get; set; } = "192.168.5.198";                             // DVR 主機位置

//        public int Port { get; set; } = 80;                                             // DVR 服務埠

//        public string Username { get; set; } = "ncut0";                                 // DVR 使用者名稱

//        public string Password { get; set; } = "ecom2828";                              // DVR 使用者密碼

//        public DateTime CurrentTime { get; set; } = new DateTime(2019, 5, 2, 12, 0, 0); // 最後備份的時間點

//        public DVR() // 每備份 30 分鐘重建
//        {
//            Peer peer = new Peer();

//            peer.Connect(Host, Port, Username, Password, "", true);

//            filename = filename + Host + Path.DirectorySeparatorChar; // data\host\

//            if (File.Exists("data" + Path.DirectorySeparatorChar + "channel.json"))
//            {
//                StreamReader sr = new StreamReader("data" + Path.DirectorySeparatorChar + "channel.json");

//                while (!sr.EndOfStream)
//                {
//                    DVRChannel channel = JsonConvert.DeserializeObject<DVRChannel>(sr.ReadLine());

//                    dict.Add(channel.ID, channel);
//                }

//                sr.Close();
//            }
//            else
//            {
//                StreamWriter sw = new StreamWriter("data" + Path.DirectorySeparatorChar + "channel.json");

//                for (int i = 0; i < 16; i++)
//                {
//                    DVRChannel channel = new DVRChannel() { ID = i, FPS = 10, Width = 1920, Height = 1080, Filename = filename, Time = CurrentTime };

//                    dict.Add(i, channel);

//                    sw.WriteLine(JsonConvert.SerializeObject(channel));

//                    sw.Flush();
//                }

//                sw.Close();
//            }

//            PeerStream stream = peer.CreateRecordedStream(CurrentTime, CurrentTime.AddMinutes(5)); // 讀取 30 分鐘的儲存資料

//            stream.Active = 1; // 0: 子碼流, 1: 主碼流

//            stream.Completed += Stream_Completed;

//            stream.ErrorOccurred += Stream_ErrorOccurred;

//            stream.VideoArrived += Stream_VideoArrived;

//            stream.Start();
//        }

//        private void Stream_VideoArrived(object sender, VideoArrivedEventArgs e)
//        {
//            if (e.Time > CurrentTime)
//            {
//                foreach (int ch in dict.Keys)
//                {
//                    if (!dict[ch].Start())
//                    {
//                        dict[ch].Dequeue();
//                    }
//                }

//                CurrentTime = e.Time;
//            }

//            dict[e.Channel].Width = e.Width;

//            dict[e.Channel].Height = e.Height;

//            dict[e.Channel].Enqueue(e.Buffer);

//            Console.WriteLine("Channel: " + e.Channel + "\t" + e.Buffer.Length + "\t(" + e.Width + ", " + e.Height + ")\t" + e.Time);
//        }

//        private void Stream_ErrorOccurred(object sender, ErrorOccurredEventArgs e)
//        {
            
//        }

//        private void Stream_Completed(object sender, CompletedEventArgs e)
//        {
            
//        }
//    }
//}
