﻿using System;
using System.Collections.Generic;
using System.Diagnostics;
using System.Drawing;
using System.Drawing.Drawing2D;
using System.Drawing.Imaging;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
// Program:
//     建立物件寫入影像與維護 FFmpeg 運行。
// History:
// 2019/05/30 
namespace DVRModel
{
    public class DVRChannel
    {
        private Queue<KeyValuePair<DateTime, byte[]>> frames = new Queue<KeyValuePair<DateTime, byte[]>>(); // 暫存的影像幀

        private MemoryStream no_motion = new MemoryStream();                                                // 無錄影的替代影像

        private bool has_motion = false;

        private string filename = "";                                                                       // 備份路徑

        private int count = 0;                                                                              // 備份分割數

        private string familyName = "Consolas";                                                             // 預設的字型格式

        private float emSize = 12;                                                                          // 預設的字型大小

        private FontStyle style = FontStyle.Regular;                                                        // 預設的字型樣式

        public int ID { get; set; }              // 攝影機編號

        public int FPS { get; set; }             // 攝影機固定幀率 (每秒多少幀)

        public int Width { get; set; }           // 攝影機影像寬度

        public int Height { get; set; }          // 攝影機影像高度

        public int Duration { get; set; }        // 影像備份長度 (分)

        public DateTime Time { get; set; }       // 最後備份的時間點

        public bool IsStop { get; private set; } // 表示外部執行緒是否完成

        private void Run()
        {
            // 前處理 - 讀取無錄影的替代影像
            FileStream f = new FileStream("lib/NoMotion.jpg", FileMode.Open);

            f.CopyTo(no_motion);

            f.Close();

            while (Width == 0 || Height == 0) { Thread.Sleep(1000 / FPS); }

            // 前處理 - 調整時間戳記的文字大小
            Graphics g = Graphics.FromImage(new Bitmap(Width, Height));

            SizeF s = g.MeasureString(Time.ToString("yyyy-MM-dd HH.mm.ss"), new Font(familyName, emSize, style));

            while (Height / 20 > s.Height)
            {
                s = g.MeasureString(Time.ToString("yyyy-MM-dd HH.mm.ss"), new Font(familyName, emSize += 1, style));
            }

            while (Height / 20 < s.Height)
            {
                s = g.MeasureString(Time.ToString("yyyy-MM-dd HH.mm.ss"), new Font(familyName, emSize -= 1, style));
            }

            DateTime time = Time; // 已處理到的時間戳記

            Process p = null;

            int len = 0;

            while (!IsStop)
            {
                if (p == null || p.HasExited)
                {
                    p = new Process();

                    p.StartInfo.FileName = "lib/ffmpeg.exe";

                    p.StartInfo.Arguments = $"-framerate {FPS} -i - -c:v libx264 -r {FPS} {filename}_{count}.mp4";

                    p.StartInfo.UseShellExecute = !(p.StartInfo.CreateNoWindow = p.StartInfo.RedirectStandardInput = true);

                    p.Start();

                    if (File.Exists($"{filename}_{count}.mp4")) { File.Delete($"{filename}_{count}.mp4"); }

                    count = count + 1;
                }
                else if (Time.AddMinutes(Duration) > time)
                {
                    if ((frames.Count == 0 ? Time.AddMinutes(Duration) : frames.Peek().Key) > time)
                    {
                        if (!has_motion)
                        {
                            MemoryStream m = new MemoryStream();

                            Bitmap b = new Bitmap(Width, Height);

                            g = Graphics.FromImage(b);

                            g.InterpolationMode = InterpolationMode.High;

                            g.SmoothingMode = SmoothingMode.HighQuality;

                            g.DrawImage(new Bitmap(no_motion), 0, 0);

                            g.DrawString(time.ToString("yyyy-MM-dd HH.mm.ss"), new Font(familyName, emSize, style), Brushes.Red, new Point(0, 0));

                            g.Save();

                            b.Save(m, ImageFormat.Jpeg);

                            no_motion.Position = 0;

                            for (int i = 0; i < FPS + len; i++)
                            {
                                byte[] buffer = m.GetBuffer();

                                Console.WriteLine($"Channel: {ID} \t Buffer: {m.GetBuffer().Length} \t Time: {time}");

                                p.StandardInput.BaseStream.Write(buffer, 0, buffer.Length);

                                p.StandardInput.BaseStream.Flush();
                            }

                            time = time.AddSeconds(1);
                        }
                        else
                        {
                            p.StandardInput.BaseStream.Close();

                            p.Close();

                            p = null;

                            len = FPS;

                            has_motion = false;
                        }
                    }
                    else if (frames.Count > 0)
                    {
                        if (has_motion)
                        {
                            Console.WriteLine($"Channel: {ID} \t Buffer: {frames.Peek().Value.Length} \t Time: {frames.Peek().Key}");

                            p.StandardInput.BaseStream.Write(frames.Peek().Value, 0, frames.Peek().Value.Length);

                            p.StandardInput.BaseStream.Flush();

                            len = len - 1;

                            time = frames.Dequeue().Key.AddSeconds(1);
                        }
                        else
                        {
                            p.StandardInput.BaseStream.Close();

                            p.Close();

                            p = null;

                            has_motion = true;
                        }
                    }
                }
                else
                {
                    StreamWriter sw = new StreamWriter($"{filename}.txt");

                    for (int i = 0; i < count; i++)
                    {
                        sw.WriteLine($"file \'{filename}_{i}.mp4\'");

                        sw.Flush();
                    }

                    if (File.Exists($"{filename}.mp4")) { File.Delete($"{filename}.mp4"); }

                    p = new Process();

                    p.StartInfo.FileName = "lib/ffmpeg.exe";
                    
                    p.StartInfo.Arguments = $"-f concat -safe 0 -i {filename}.txt -c:v libx264 -r {FPS} {filename}.mp4";

                    p.StartInfo.UseShellExecute = !(p.StartInfo.CreateNoWindow = true);

                    p.ErrorDataReceived += P_ErrorDataReceived;

                    p.Start();

                    while (!p.HasExited)
                    {
                        Console.Write('.');

                        Thread.Sleep(1000 / FPS);
                    }

                    IsStop = true;
                }
            }
            Time = Time.AddMinutes(Duration);
        }

        private void P_ErrorDataReceived(object sender, DataReceivedEventArgs e)
        {
            Console.WriteLine(e.Data);
        }

        public void Start(string path) // [CH01] 2019-04-19 00.00.00.mp4
        {
            Thread thread = new Thread(Run);

            filename = !path.EndsWith(Convert.ToString(Path.DirectorySeparatorChar)) ? path + Path.DirectorySeparatorChar : path;

            filename = filename + "[CH" + Convert.ToString(ID + 1).PadLeft(2, '0') + "]_" + Time.ToString("yyyy-MM-dd_HH.mm.ss");

            IsStop = false;
            
            thread.Start();
        }

        public void Stop()
        {
            IsStop = true;
        }

        public void Enqueue(DateTime timestamp, byte[] buffer)
        {
            KeyValuePair<DateTime, byte[]> pair = new KeyValuePair<DateTime, byte[]>(timestamp, buffer);

            frames.Enqueue(pair);
        }
    }
}
