#pragma once

#include <stdio.h>

#define ICARCH_WIN32
// #define ICARCH_WIN64
// #define ICARCH_MAC
// #define ICARCH_IOS
// #define ICARCH_ANDROID
// #define ICARCH_LINUX32
// #define ICARCH_LINUX64
// #define ICARCH_HI3531

#include "PeerSDK.h"

#include "DiagnosticTool.h"

#if defined (ICARCH_WIN32) || defined (ICARCH_WIN64)

    #include <conio.h>

    #define WRITE_LOG(format, ...)   wprintf(format, __VA_ARGS__)
    #define GETCHAR()  _getch()

#elif defined (ICARCH_IOS) \
    ||defined (ICARCH_MAC) \
    ||defined (ICARCH_LINUX32) \
    ||defined (ICARCH_LINUX64) \
    ||defined (ICARCH_ANDROID) \
    ||defined (ICARCH_HI3531)

    #define WRITE_LOG(format...)     wprintf(format)

#endif

#define RESULT_CHECK(cmd)  \
    { \
        PeerResult r = cmd; \
        if (!r) \
        { \
            WRITE_LOG(L"[ERROR] "); \
            WRITE_LOG(r.Message()); \
            WRITE_LOG(L"\n"); \
            return r; \
        } \
    }
