// #define ICARCH_WIN32
// #define ICARCH_IOS_ARM7

#include <PeerSDK.h>
using namespace PeerSDK;

#include <stdio.h>

Peer* m_peer = NULL;

int Finalize(int code)
{
    delete m_peer;

    Peer::Cleanup();
    return code;
}

int main()
{
    PeerResult r;

    r = Peer::Startup();
    if (!r)
    {
        printf("*** failed to initialize\n");
        return Finalize(-1);
    }

    m_peer = new Peer();
    r = m_peer->Connect("192.168.3.43", 80, "Admin", "123456", "", true);
    if (!r)
    {
        printf("*** failed to connect\n");
        return Finalize(-1);
    }

    PeerRecorder* recorder = m_peer->Recorder();

    RecordScheme scheme = recorder->DefaultRecordScheme(); // get default recorder scheme
    for (int i = 0; i < scheme.Channels().Count(); i++) // change record scheme of every channel
    {
        ChannelScheme channel = scheme.Channels()[i];
        channel.EnableRegularRecord(channel.RegularResolution(), 15, 1.0, true); // change FPS to 15, quality is best, record audio
    }
    recorder->SetDefaultRecordScheme(scheme); // update DVR setting

    return Finalize(0);
}
