﻿using System;
using System.Windows;
using Microsoft.Win32;
using PeerSDK.Wrapper;

namespace PeerSDK.Samples
{
    public partial class LoginWindow : Window
    {
        public LoginWindow()
        {
            Host = "192.168.3.59";
            Port = 80;
            User = "Admin";
            Password = "123456";

            DataContext = this;

            InitializeComponent();
        }

        public string Host { get; set; }
        public int Port { get; set; }
        public string User { get; set; }
        public string Password { get; set; }

        void Connect_OnClick(object sender, RoutedEventArgs e)
        {
            Peer peer = new Peer();
            try
            {
                peer.Connect(Host, Port, User, Password, null, true);
            }
            catch (Exception ex)
            {
                MessageBox.Show(ex.Message);
                return;
            }
            PeerWindow window = new PeerWindow(peer) { Owner = this, Title = String.Format("{0}:{1}", Host, Port) };
            window.ShowDialog();
        }

        void OpenIRF_OnClick(object sender, RoutedEventArgs e)
        {
            OpenFileDialog dialog = new OpenFileDialog() { DefaultExt = ".irf", Filter = "IRF files|*.irf|All Files|*.*" };
            if (dialog.ShowDialog(this) == true)
            {
                IrfWindow window = new IrfWindow(new IrfFile(dialog.FileName)) { Owner = this };
                window.ShowDialog();
            }
        }
    }
}