﻿using System;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Windows;
using PeerSDK.Wrapper;

namespace PeerSDK.Samples
{
    public partial class PeerWindow : Window
    {
        public PeerWindow(Peer peer)
        {
            Peer = peer;
            Peer.ErrorOccurred += Peer_ErrorOccurred;
            Peer.VideoLossChanged += Peer_VideoLossChanged;
            Peer.VideoMotionChanged += Peer_VideoMotionChanged;
            Peer.RecordStatusChanged += Peer_RecordStatusChanged;

            string[] detections = typeof(VideoFormatDetection).GetEnumNames();
            AvailableVideoFormatDetection = new Tuple<VideoFormatDetection, bool>[detections.Length];
            for (int i = 0; i < detections.Length; i++)
            {
                VideoFormatDetection v = (VideoFormatDetection)Enum.Parse(typeof(VideoFormatDetection), detections[i]);
                AvailableVideoFormatDetection[i] = Tuple.Create(v, Peer.IsAvailableVideoFormatDetection(v));
            }

            DataContext = this;

            HDDs = new ObservableCollection<PeerHDD>();

            InitializeComponent();
        }

        public Peer Peer { get; private set; }
        public Tuple<VideoFormatDetection, bool>[] AvailableVideoFormatDetection { get; private set; }

        void Window_Closed(object sender, EventArgs e)
        {
            if (Peer != null)
                Peer.Dispose();
        }

        void Peer_ErrorOccurred(object sender, ErrorOccurredEventArgs e)
        {
        }

        void Peer_VideoLossChanged(object sender, VideoLossChangedEventArgs e)
        {
        }

        void Peer_VideoMotionChanged(object sender, VideoMotionChangedEventArgs e)
        {
        }

        void Peer_RecordStatusChanged(object sender, RecordStatusChangedEventArgs e)
        {
        }

        void CreateLiveStream_OnClick(object sender, RoutedEventArgs e)
        {
            LiveStreamWindow window = new LiveStreamWindow(Peer) { Owner = this };
            window.Show();
        }

        void CreatePlaybackStream_OnClick(object sender, RoutedEventArgs e)
        {

        }

        void CreateBackupStream_OnClick(object sender, RoutedEventArgs e)
        {
        }

        void CreateRecordList_OnClick(object sender, RoutedEventArgs e)
        {
            RecordListWindow window = new RecordListWindow(Peer) { Owner = this };
            window.Show();
        }

        void GetLogList_OnClick(object sender, RoutedEventArgs e)
        {
            PeerLog[] logs = Peer.GetLogList();

            LogWindow window = new LogWindow(logs) { Owner = this };
            window.ShowDialog();
        }

        void GetHDDList_OnClick(object sender, RoutedEventArgs e)
        {
            HDDs.Clear();
            foreach (var i in Peer.GetHDDList())
                HDDs.Add(i);
        }

        public ObservableCollection<PeerHDD> HDDs { get; private set; }

        void Ack_OnClick(object sender, RoutedEventArgs e)
        {
            Peer.Ack();
        }

        void VideoFormatDetection_Click(object sender, RoutedEventArgs e)
        {
            // Need reboot, mark this code
            //             FrameworkElement f = sender as FrameworkElement;
            //             Peer.SetVideoFormatDetectMethod((VideoFormatDetection)f.Tag);
        }
    }
}