﻿using System;
using System.ComponentModel;
using System.Globalization;
using System.Windows;
using System.Windows.Data;
using PeerSDK.Wrapper;

namespace PeerSDK.Samples
{
    public partial class IrfWindow : Window, INotifyPropertyChanged
    {
        public IrfWindow(IrfFile file)
        {
            File = file;

            DataContext = this;

            InitializeComponent();
        }

        public IrfFile File { get; private set; }

        void Window_Closed(object sender, EventArgs e)
        {
            if (File != null)
                File.Close();
        }

        void GetNextFrame_OnClick(object sender, RoutedEventArgs e)
        {
            Type = File.CheckNextFrameType();
            switch (Type)
            {
                case IrfFrameType.Video:
                    Video = File.GetNextVideoFrame();
                    break;
                case IrfFrameType.Audio:
                    Audio = File.GetNextAudioFrame();
                    break;
            }

            if (PropertyChanged != null)
            {
                PropertyChanged(this, new PropertyChangedEventArgs("Type"));
                PropertyChanged(this, new PropertyChangedEventArgs("Video"));
                PropertyChanged(this, new PropertyChangedEventArgs("Audio"));
            }
        }

        public IrfFrameType Type { get; private set; }
        public IrfVideoFrame Video { get; private set; }
        public IrfAudioFrame Audio { get; private set; }

        public event PropertyChangedEventHandler PropertyChanged;
    }

    [ValueConversion(typeof(IrfFrameType), typeof(Visibility))]
    public class IrfFrameTypeConverter : IValueConverter
    {
        public object Convert(object value, Type targetType, object parameter, CultureInfo culture)
        {
            IrfFrameType type = (IrfFrameType)value;
            IrfFrameType v = (IrfFrameType)Enum.Parse(typeof(IrfFrameType), (string)parameter);
            return type == v ? Visibility.Visible : Visibility.Collapsed;
        }

        public object ConvertBack(object value, Type targetType, object parameter, CultureInfo culture)
        {
            throw new NotImplementedException();
        }
    }
}