#pragma once

#ifndef PEERSDK_PROTECT
#pragma message("please include PeerSDK.h instead of me")
#endif

/**
* @brief Represents a <b>Sensor</b> list of objects that can be accessed by index.
*/
class PEERSDK_API SensorCollection
{
    PEERSDK_DECLARE_IMPL()

public:
    /** @name Constructors
    */
    //@{

    /**
    * @private
    */
    SensorCollection();

    /**
    * @private
    */
    SensorCollection(SensorCollection const& value);

    /**
    * @private
    */
    ~SensorCollection();
    //@}

public:
    /** @name Properties
    */
    //@{

    /**
    * Gets the number of elements actually contained in the <b>SensorCollection</b>.
    */
    int32 Count() const;
    //@}

public:
    /** @name Operators
    */
    //@{

    /**
    * Replaces the elements of the <b>SensorCollection</b> with a copy of another <b>SensorCollection</b>.
    */
    SensorCollection& operator=(SensorCollection const& value);

    /**
    * Returns a pointer in the <b>SensorCollection</b> element at a specified position.
    */
    PeerSensor* operator[](int32 index) const;
    //@}
};
