// #define ICARCH_WIN32
// #define ICARCH_IOS_ARM7
#ifdef __cplusplus  
extern "C" {  
#endif  
#include <PeerSDK.h>
using namespace PeerSDK;
#ifdef __cplusplus  
}  
#endif  
  
#include <stdio.h>

Peer* m_peer = NULL;

int Finalize(int code)
{
    delete m_peer;

    Peer::Cleanup();
    return code;
}

void PEERSDK_CALLBACK OnErrorOccurred(void* tag, ErrorOccurredEventArgs const& e)
{
    printf("*** error occurred\n");
}

void PEERSDK_CALLBACK OnVideoLossChanged(void* tag, VideoLossChangedEventArgs const& e)
{
    for (int i = 0; i < e.Active().Count(); i++)
    {
        printf("[%02d] video loss\n", e.Active()[i]);
    }
    for (int i = 0; i < e.Deactive().Count(); i++)
    {
        printf("[%02d] video normal\n", e.Deactive()[i]);
    }
}

void PEERSDK_CALLBACK OnVideoMotionChanged(void* tag, VideoMotionChangedEventArgs const& e)
{
    for (int i = 0; i < e.Active().Count(); i++)
    {
        printf("[%02d] video motion\n", e.Active()[i]);
    }
    for (int i = 0; i < e.Deactive().Count(); i++)
    {
        printf("[%02d] video static\n", e.Deactive()[i]);
    }
}

int main()
{
    PeerResult r = Peer::Startup();
    if (!r)
    {
        printf("*** failed to initialize\n");
        return Finalize(-1);
    }

    m_peer = new Peer();
    r = m_peer->Connect("192.168.3.38", 80, "admin", "123456", "", true);
    if (!r)
    {
        printf("*** failed to connect\n");
        return Finalize(-1);
    }

    printf("Channel Count: %d\n", m_peer->Channels().Count());

    m_peer->ErrorOccurred().Add(NULL, OnErrorOccurred);
    m_peer->VideoLossChanged().Add(NULL, OnVideoLossChanged);
    m_peer->VideoMotionChanged().Add(NULL, OnVideoMotionChanged);

    while (true) {

    }

    return Finalize(0);
}
