#pragma once

#ifndef PEERSDK_PROTECT
#pragma message("please include PeerSDK.h instead of me")
#endif

/**
* @brief Represents sensor switch.
*/
class PEERSDK_API PeerSensor
{
    PEERSDK_DECLARE_IMPL()

public:
    /** @name Constructors
    */
    //@{

    /**
    * @private
    */
    PeerSensor(_R* peer, int32 index);

    /**
    * @private
    */
    ~PeerSensor();
    //@}

public:
    /** @name Properties
    */
    //@{

    /**
    * Gets current sensor pole.
    */
    int32 Index() const;

    /**
    * Gets current sensor pole.
    */
    bool Enabled() const;

    /**
    * Gets current sensor pole.
    */
    Polarity SensorPolarity() const;

    /**
    * Gets current sensor pole.
    */
    bool IsTriggered() const;
    //@}
};
