﻿using System;
using System.Collections.ObjectModel;
using System.ComponentModel;
using System.Windows;
using System.Windows.Controls;
using PeerSDK.Wrapper;

namespace PeerSDK.Samples
{
    public partial class RecordListWindow : Window, INotifyPropertyChanged
    {
        public RecordListWindow(Peer peer)
        {
            RecordList = peer.CreateRecordList();

            Year = 2012;
            Month = 7;

            Days = new ObservableCollection<int>();
            Minutes = new ObservableCollection<TimeSpan>();

            DataContext = this;

            InitializeComponent();
        }

        public PeerRecordList RecordList { get; private set; }

        void Window_Closed(object sender, EventArgs e)
        {
            if (RecordList != null)
                RecordList.Dispose();
        }

        public int Year { get; set; }
        public int Month { get; set; }

        public event PropertyChangedEventHandler PropertyChanged;

        public ObservableCollection<int> Days { get; private set; }
        public ObservableCollection<TimeSpan> Minutes { get; private set; }

        void GetRecordedDaysOfMonth_OnClick(object sender, RoutedEventArgs e)
        {
            Days.Clear();
            foreach (var i in RecordList.GetRecordedDaysOfMonth(Year, Month + 1))
            {
                Days.Add(i);
            }
        }

        void Day_SelectionChanged(object sender, SelectionChangedEventArgs e)
        {
            ListBox listbox = sender as ListBox;
            Minutes.Clear();
            foreach (var i in RecordList.GetRecordedMinutesOfDay(Year, Month + 1, (int)listbox.SelectedItem))
            {
                Minutes.Add(i);
            }
        }
    }
}