﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
// Program:
//   ROI 資料模型。
// History:
// 2019/07/17 建立資料模型。
namespace ETC2019.Models
{
    public class ROIModel
    {
        public DateTime CreateDT { get; set; } // 資料建立時間
        public DateTime ModifyDT { get; set; } // 資料修改時間
        public ROI[] Items { get; set; }       // 資料集合
        public Rectangle[] Mapping(int width, int height)
        {
            Rectangle[] rect = new Rectangle[Items.Length];

            for (int i = 0; i < rect.Length; i++)
            {
                int x = Convert.ToInt32(Math.Round(Items[i].X * width));

                int y = Convert.ToInt32(Math.Round(Items[i].Y * height));

                int w = Convert.ToInt32(Math.Round(Items[i].Width * width));

                int h = Convert.ToInt32(Math.Round(Items[i].Height * height));

                rect[i] = new Rectangle(x, y, w, h);
            }

            return rect;
        }
    }
}
