﻿using ETC2019.Controllers;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ETC2019.Views
{
    public partial class BarcodePage : Form
    {
        private BarcodeController Controller { get; set; }
        public BarcodePage()
        {
            InitializeComponent();

            Controller = new BarcodeController();
        }

        private void CodePage_Resize(object sender, EventArgs e)
        {
            Text = string.Format("{0} x {1}", ClientSize.Width, ClientSize.Height);

            try
            {
                Clipboard.SetText(string.Format("{0}, {1}", Size.Width, Size.Height));
            }
            catch { }
        }

        private void ToolStrip1_Resize(object sender, EventArgs e)
        {
            int width = Controller.AvailableWidth(toolStrip1.Size.Width - toolStrip1.Padding.Left - toolStrip1.Padding.Right, toolStrip1.Items);

            toolStripTextBox1.Size = new Size(width, toolStripTextBox1.Size.Height);
        }

        private void ToolStripButton1_Click(object sender, EventArgs e)
        {
            if (folderBrowserDialog1.ShowDialog() == DialogResult.OK && Controller.LoadFolder(folderBrowserDialog1.SelectedPath, out string[] items))
            {
                listBox1.Items.Clear();

                listBox1.Items.AddRange(items);
            }
        }
    }
}
