﻿using ETC2019.Models;
using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;

namespace ETC2019.Controllers
{
    public class BarcodeController
    {
        public delegate void MessageShowEventHandler(string message);
        public event MessageShowEventHandler MessageShow;
        private Configuration Config { get; set; }
        public Dictionary<string, string> PairMetered { get; set; }
        public Dictionary<string, string> Pair { get; set; }
        public BackgroundWorker Selector { get; set; }
        public event RunWorkerCompletedEventHandler SelectorRunWorkerCompleted
        {
            add => Selector.RunWorkerCompleted += value;
            remove => Selector.RunWorkerCompleted -= value;
        }
        /* 其他參數 */
        public string SystemText { get => string.Format("{0}v{1}", Config.SystemName, Config.SystemVersion); }
        public Return[] Returns
        {
            get
            {
                List<Return> items = new List<Return>(Config.Return.Items);

                items.Sort();

                return items.ToArray();
            }
        }

        public BarcodeController()
        {
            Config = File.Exists("config.json") ? JsonConvert.DeserializeObject<Configuration>(ReadToEnd("config.json")) : Configuration.Default();

            Config.SystemName = "ETC寄存退件註記工具(刷)";

            Config.SystemVersion = "1.1.8";

            Pair = new Dictionary<string, string>();

            Pair.Add("冊號", "bookno");

            Pair.Add("單號", "tkt_no");

            Pair.Add("原因", "rsn");

            Pair.Add("處理日期", "r_date");

            Pair.Add("寄存日期", "寄存日");

            PairMetered = new Dictionary<string, string>();

            PairMetered.Add("冊頁號", "bookno");

            PairMetered.Add("車號", "plt_no");

            PairMetered.Add("車主", "owner");

            PairMetered.Add("車主區號", "zip");

            PairMetered.Add("車主地址", "o_addr");

            PairMetered.Add("駕駛", "");

            PairMetered.Add("駕駛區號", "");

            PairMetered.Add("駕駛地址", "");

            PairMetered.Add("應到案處所", "sup_name");

            PairMetered.Add("舉發單位", "plic");
        }
        // 讀取檔案的所有內容。
        private string ReadToEnd(string json)
        {
            using (StreamReader sr = new StreamReader("config.json"))
                return sr.ReadToEnd();
        }

        public string[] SelectAll(string bookID, string returnKey)
        {
            SQL etc = Config.SQL.Pairs["[nhpb].[dbo].[ETC寄存退件主檔_97]"];

            DataRowCollection row = etc.SelectLike(false, "bookno", bookID);

            if (row.Count > 0)
                return (from DataRow item in row select item[returnKey] as string).Distinct().ToArray();
            else
                return new string[0];
        }

        public int[] SelectCount(string bookID)
        {
            SQL etc = Config.SQL.Pairs["[nhpb].[dbo].[ETC寄存退件主檔_97]"];

            DataRowCollection row = etc.SelectLike(false, "bookno", bookID);

            if (row.Count > 0)
                return (from DataRow item in row
                        let text = item["bookno"] as string
                        let len = text.Length
                        let indexText = text.Substring(len - 3, 3)
                        select int.TryParse(indexText, out int index) ? index : 0).Distinct().ToArray();
            else
                return new int[0];
        }

        public Dictionary<string, string> Select(string ID, string bookID)
        {
            SQL etcMetered = Config.SQL.Pairs["[nhpb].[dbo].[etcMetered]"];

            //SQL etcMetered2 = Config.SQL.Pairs["[nhpb].[dbo].[ETC二次寄存主檔]"];

            SQL etc = Config.SQL.Pairs["[nhpb].[dbo].[ETC寄存退件主檔_97]"];

            DataRowCollection rowMetered = etcMetered.Select(true, "tkt_no", new string[] { ID });

            //DataRowCollection rowMetered2 = etcMetered2.Select(true, "tkt_no", new string[] { ID });

            DataRowCollection row = etc.SelectAnd(false, new Dictionary<string, string>() {
                { "tkt_no", ID },
                { "bookno", bookID },
            });

            Dictionary<string, string> pair = new Dictionary<string, string>();

            if (row.Count == 1)
            {
                pair.Add("bookno", bookID);

                pair.Add("tkt_no", ID);

                if (rowMetered.Count == 1)
                {
                    pair.Add("rsn", row[0]["rsn"] as string);

                    pair.Add("r_date", row[0]["r_date"] as string);

                    pair.Add("寄存日", row[0]["寄存日"] as string);

                    pair.Add("冊頁號", rowMetered[rowMetered.Count - 1]["bookno"] as string);

                    pair.Add("車號", rowMetered[rowMetered.Count - 1]["plt_no"] as string);

                    pair.Add("車主", rowMetered[rowMetered.Count - 1]["owner"] as string);

                    pair.Add("車主區號", rowMetered[rowMetered.Count - 1]["zip"] as string);

                    pair.Add("車主地址", rowMetered[rowMetered.Count - 1]["o_addr"] as string);

                    //pair.Add("冊頁號", rowMetered2[rowMetered2.Count - 1]["bookno"] as string);

                    //pair.Add("車號", rowMetered2[rowMetered2.Count - 1]["plt_no"] as string);

                    //pair.Add("車主", rowMetered2[rowMetered2.Count - 1]["name"] as string);

                    //pair.Add("車主區號", rowMetered2[rowMetered2.Count - 1]["zip"] as string);

                    //pair.Add("車主地址", rowMetered2[rowMetered2.Count - 1]["addr"] as string);

                    pair.Add("駕駛", "");

                    pair.Add("駕駛區號", "");

                    pair.Add("駕駛地址", "");

                    pair.Add("應到案處所", rowMetered[0]["sup_name"] as string);

                    pair.Add("舉發單位", rowMetered[0]["plic"] as string);
                }
            }
            return pair;
        }

        public string[] Insert(string typeID, object returnID, string bookID, string depositDT, string ID, out string returnBook)
        {
            //SQL etcMetered = Config.SQL.Pairs["[nhpb].[dbo].[ETC二次寄存主檔]"];

            //SQL etc = Config.SQL.Pairs["[nhpb].[dbo].[ETC二次寄存退件主檔]"];

            SQL etcMetered = Config.SQL.Pairs["[nhpb].[dbo].[etcMetered]"];

            SQL etc = Config.SQL.Pairs["[nhpb].[dbo].[ETC寄存退件主檔_97]"];

            DataRowCollection find = etcMetered.Select(false, "tkt_no", new string[] { ID });

            DataRowCollection row = etc.Select(true, "tkt_no", new string[] { ID });

            string book = string.Empty;

            if (find.Count > 0)
            {
                if (row.Count > 0)
                {
                    Dictionary<string, string> where = new Dictionary<string, string>()
                    {
                        { "tkt_no", ID },
                        { "thing", typeID },
                    };

                    row = etc.SelectAnd(true, where);
                }

                if (row.Count == 0)
                {
                    //DataRowCollection rowMetered = etcMetered.Select(false, "post_no20", new string[] { find[0]["post_no20"] as string });

                    DataRowCollection rowMetered = etcMetered.Select(false, "post_no2", new string[] { find[0]["post_no2"] as string });

                    if (rowMetered.Count > 0)
                    {
                        //DataRow[] rows = (from DataRow temp in rowMetered where temp["post_dt"] as string == find[0]["post_dt"] as string select temp).ToArray();

                        DataRow[] rows = (from DataRow temp in rowMetered where temp["post_date"] as string == find[0]["post_date"] as string select temp).ToArray();

                        int[] index = SelectCount(string.Format("{0}%", bookID));

                        int insertIndex = 1;

                        if (index.Length > 0)
                            for (int i = 1; i <= (index.Max() + 1); i++)
                                if (!index.Contains(i))
                                {
                                    insertIndex = i;

                                    break;
                                }

                        book = string.Format("{0}{1}", bookID, Convert.ToString(Convert.ToInt32(insertIndex)).PadLeft(3, '0'));

                        List<string[]> values = (from temp in rows
                                                 select new string[] {
                            string.Format("{0}{1}", DateTime.Now.Year - 1911, DateTime.Now.ToString("MMdd")),
                            book,
                            (returnID as Return).ID,     // 註記代號
                            temp["tkt_no"] as string,    // 單號
                            typeID,                      // 3 : 紅單+送達證 2 : 1 :
                            depositDT,                   // 寄存日
                            temp["accuse_no"] as string, // 郵局代號
                        }).ToList();

                        returnBook = book;

                        return etc.Insert(values) ? (from temp in rows select temp["tkt_no"] as string).ToArray() : new string[0];
                    }
                    else
                        MessageShow?.Invoke(string.Format("Cannot find out the '{0}' in table.", find[0]["post_no20"]));
                }
                else
                    MessageShow?.Invoke(string.Format("'{0}' has been insert to database with same arguments.", ID));
            }
            else
                MessageShow?.Invoke(string.Format("Cannot find out the '{0}' in table.", ID));

            returnBook = book;

            return new string[0];
        }

        public bool Delete(string bookID)
        {
            //SQL etc = Config.SQL.Pairs["[nhpb].[dbo].[ETC二次寄存退件主檔]"];

            SQL etc = Config.SQL.Pairs["[nhpb].[dbo].[ETC寄存退件主檔_97]"];

            return etc.Delete("bookno", new string[] { bookID });
        }

        internal void Save()
        {
            Config.Save("");
        }

        //internal bool Update(string updateKey, string update, string id)
        //{
        //    if (Pair.ContainsKey(updateKey))
        //    {
        //        //SQL etc = Config.SQL.Pairs["[nhpb].[dbo].[ETC二次寄存退件主檔]"];

        //        SQL etc = Config.SQL.Pairs["[nhpb].[dbo].[ETC寄存退件主檔_97]"];

        //        return etc.Update(Pair[updateKey], update, "tkt_no", id);
        //    }
        //    if (PairMetered.ContainsKey(updateKey))
        //    {
        //        //SQL etcMetered = Config.SQL.Pairs["[nhpb].[dbo].[ETC二次寄存主檔]"];

        //        SQL etcMetered = Config.SQL.Pairs["[nhpb].[dbo].[etcMetered]"];

        //        return etcMetered.Update(PairMetered[updateKey], update, "tkt_no", id);
        //    }
        //    return false;
        //}

        internal bool Update(string updateKey, string update, string bookno)
        {
            if (Pair.ContainsKey(updateKey) && !updateKey.Equals("單號"))
            {
                //SQL etc = Config.SQL.Pairs["[nhpb].[dbo].[ETC二次寄存退件主檔]"];

                SQL etc = Config.SQL.Pairs["[nhpb].[dbo].[ETC寄存退件主檔_97]"];

                return etc.Update(Pair[updateKey], update, "bookno", bookno);
            }
            if (PairMetered.ContainsKey(updateKey))
            {
                //SQL etcMetered = Config.SQL.Pairs["[nhpb].[dbo].[ETC二次寄存主檔]"];

                SQL etcMetered = Config.SQL.Pairs["[nhpb].[dbo].[etcMetered]"];

                return etcMetered.Update(PairMetered[updateKey], update, "bookno", bookno);
            }
            return false;
        }
    }
}
