﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Data;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
// Program:
//   註記資料模型。
// History:
// 2019/07/26 新增 ToArray() 方法，回傳項目清單。
namespace ETC2019.Models
{
    public class ReturnModel
    {
        //public DateTime CreateDT { get; set; }
        //public DateTime ModifyDT { get; set; }
        public Return[] Items { get; set; }
        [JsonIgnore]
        public Dictionary<string, Return> Pairs
        {
            get
            {
                Dictionary<string, Return> pairs = new Dictionary<string, Return>();

                for (int i = 0; i < Items.Length; i++)
                    pairs.Add(Items[i].ID, Items[i]);

                return pairs;
            }
        }

        public string[] ToArray()
        {
            return (from i in Items select i.ToString()).ToArray();
        }

        public void Default(SQLModel sql)
        {
            DataRowCollection rows = sql.Pairs["[nhpb].[dbo].[return]"].Select(true);

            Items = (from DataRow item in rows select new Return() { ID = item[0] as string, Text = item[1] as string }).ToArray();
        }

        public void Save(string path)
        {
            using (StreamWriter sw = new StreamWriter(Path.Combine(path, Path.Combine("data", "return.json"))))
            {
                sw.Write(JsonConvert.SerializeObject(this, Formatting.Indented));

                sw.Flush();

                sw.Close();
            }
        }
    }
}
