﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
// Program:
//   ROI 資料模型。
// History:
// 2019/08/20 建立資料模型。
namespace ETC2019.Models
{
    public class ROIModel
    {
        //public DateTime CreateDT { get; set; }
        //public DateTime ModifyDT { get; set; }
        public ROI[] Items { get; set; }

        public Rectangle[] Mapping(int width, int height)
        {
            return (from i in Items
                    let x1 = Convert.ToInt32(Math.Round(i.X1 * width))
                    let y1 = Convert.ToInt32(Math.Round(i.Y1 * height))
                    let x2 = Convert.ToInt32(Math.Round(i.X2 * width))
                    let y2 = Convert.ToInt32(Math.Round(i.Y2 * height))
                    select new Rectangle(x1, y1, x2 - x1, y2 - y1)).ToArray();
        }
    }
}
