﻿using Newtonsoft.Json;
using System.Collections.Generic;
using System.IO;
// Program:
//   SQL 資料模型。
// History:
// 2019/08/20 建立資料模型。
// 2019/08/27 新增預設值。
namespace ETC2019.Models
{
    public class SQLModel
    {
        //public DateTime CreateDT { get; set; }
        //public DateTime ModifyDT { get; set; }
        public SQL[] Items { get; set; }
        [JsonIgnore]
        public Dictionary<string, SQL> Pairs
        {
            get
            {
                Dictionary<string, SQL> pairs = new Dictionary<string, SQL>();

                for (int i = 0; i < Items.Length; i++)
                    pairs.Add(Items[i].Table, Items[i]);

                return pairs;
            }
        }

        public void Default()
        {
            Items = new SQL[]
            {
                new SQL()
                {
                    Table = "[nhpb].[dbo].[return]",
                    Columns = "[code],[name]",
                    OrderBy = "[code]",
                },
                new SQL()
                {
                    //DataSource = "192.168.6.233",
                    //InitialCatalog = "nhpb",
                    //UserID = "sa",
                    //Password = "jack",
                    Table = "[nhpb].[dbo].[etcMetered]",
                    Columns = "*",
                    OrderBy = "[bookno]",
                },
                new SQL()
                {
                    //DataSource = "192.168.6.233",
                    //InitialCatalog = "nhpb",
                    //UserID = "sa",
                    //Password = "jack",
                    Table = "[nhpb].[dbo].[ETC寄存退件主檔_97]",
                    Columns = "[r_date],[bookno],[rsn],[tkt_no],[thing],[寄存日],[accuse_no]",
                    OrderBy = "[tkt_no]",
                },
            };
        }

        public void Save(string path)
        {
            using (StreamWriter sw = new StreamWriter(Path.Combine(path, Path.Combine("data", "sql.json"))))
            {
                sw.Write(JsonConvert.SerializeObject(this, Formatting.Indented));

                sw.Flush();

                sw.Close();
            }
        }

        //private SqlConnectionStringBuilder Builder { get; set; }
        //public SQLModel()
        //{
        //    Builder = new SqlConnectionStringBuilder();

        //    Builder.DataSource = "192.168.6.233";

        //    Builder.InitialCatalog = "nhpb";

        //    Builder.UserID = "sa";

        //    Builder.Password = "jack";
        //}

        //public ReturnModel SelectReturns(ReturnModel model)
        //{

        //}

        //public Dictionary<string, DataRow> SelectETC(string[] id)
        //{
        //    Dictionary<string, DataRow> table = new Dictionary<string, DataRow>();

        //    if (id.Length > 0)
        //    {
        //        string ids = string.Format("tkt_no = '{0}'", id[0]);

        //        for (int i = 1; i < id.Length; i++)
        //            ids = ids + string.Format(" OR tkt_no = '{0}'", id[i]);

        //        if (!string.IsNullOrEmpty(ids))
        //        {
        //            using (SqlConnection db = new SqlConnection(Builder.ConnectionString))
        //            {
        //                db.Open();

        //                string cmd = string.Format("SELECT * FROM [nhpb].[dbo].[etcMetered] WHERE {0}", ids);

        //                using (SqlDataAdapter query = new SqlDataAdapter(cmd, db))
        //                {
        //                    DataTable temp = new DataTable();

        //                    query.Fill(temp);

        //                    foreach (DataRow row in temp.Rows)
        //                        table.Add(row["tkt_no"] as string, row);

        //                    db.Close();
        //                }
        //            }
        //        }
        //    }

        //    return table;
        //}

        //public bool ContainsETC(string id, out string rsn)
        //{
        //    using (SqlConnection db = new SqlConnection(Builder.ConnectionString))
        //    {
        //        db.Open();

        //        string cmd = string.Format("SELECT rsn FROM [nhpb].[dbo].[ETC寄存退件主檔_97] WHERE tkt_no = '{0}'", id);

        //        using (SqlDataAdapter query = new SqlDataAdapter(cmd, db))
        //        {
        //            DataTable table = new DataTable();

        //            query.Fill(table);

        //            rsn = table.Rows.Count > 0 ? table.Rows[0]["rsn"] as string : string.Empty;

        //            db.Close();
        //        }

        //        return string.IsNullOrEmpty(rsn);
        //    }
        //}
    }
}
