﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ETC2019.Controllers
{
    public class BarcodeController
    {
        private string[] AllowExtension { get; set; }
        private string[] Items { get; set; }
        public BarcodeController()
        {
            AllowExtension = new string[] { ".jpg", ".jpeg", ".gif" };
        }

        public int AvailableWidth(int width, ToolStripItemCollection items)
        {
            foreach (ToolStripItem item in items)
            {
                if (item is ToolStripTextBox || item is ToolStripComboBox) { continue; }
                else
                    width = width - item.Size.Width - item.Margin.Left - item.Margin.Right;
            }
            return width;
        }

        public Bitmap Get(int index)
        {

        }

        public bool LoadFolder(string path, out string[] items)
        {
            List<string> itemList = new List<string>(Items = FolderIterator(path, out string[] tempItems) ? tempItems : new string[0]);

            for (int i = 0; i < itemList.Count; i++)
                itemList[i] = Path.GetFileNameWithoutExtension(itemList[i]);

            items = itemList.ToArray();

            return items.Length > 0;
        }

        private bool FolderIterator(string path, out string[] items)
        {
            List<string> itemList = new List<string>();

            foreach (string d in Directory.GetDirectories(path))
                if (FolderIterator(d, out string[] tempItems))
                    itemList.AddRange(tempItems);

            foreach (string f in Directory.GetFiles(path))
                if (AllowExtension.Contains(Path.GetExtension(f)))
                    itemList.Add(f);

            items = itemList.ToArray();

            return items.Length > 0;
        }
    }
}
