﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
// Program:
//   管理程式運行的通用參數。
// History:
// 2919/08/20
namespace ETC2019.Models
{
    public class Configuration
    {
        public DateTime CreateDT { get; set; }
        public DateTime ModifyDT { get; set; }
        public SQLModel SQL { get; set; }
        public ROIModel ROI { get; set; }
        public ReturnModel Return { get; set; }
        public string[] AllowExtension { get; set; }
        public string SelectedPath { get; set; }
        public string SystemName { get; set; }
        public string SystemVersion { get; set; }

        public static Configuration Default()
        {
            Configuration config = new Configuration() { CreateDT = DateTime.Now, ModifyDT = DateTime.Now };

            config.AllowExtension = new string[] { ".jpg", ".jpeg", ".bmp", ".gif" };

            config.Return = new ReturnModel();

            config.ROI = new ROIModel() { Items = new ROI[] { new ROI() { X1 = 0.8, Y1 = 0.8, X2 = 1, Y2 = 1 } } };

            config.SQL = new SQLModel();

            config.SQL.Default();

            config.Return.Default(config.SQL);

            return config;
        }

        public void Save(string path)
        {
            using (StreamWriter sw = new StreamWriter(Path.Combine(path, "config.json")))
            {
                sw.Write(JsonConvert.SerializeObject(this, Formatting.Indented));

                sw.Flush();

                sw.Close();
            }
        }
    }
}
