﻿using Newtonsoft.Json;
using System;
using System.Collections.Generic;
using System.IO;
using System.Linq;
// Program:
//   資料處理模型。
// History:
// 2019/07/22 建立資料模型。
// 2019/07/23 新增處理編號。
// 2019/07/26 連線資料庫取得註記。
// 2019/08/19 新增 ToArray() 方法，回傳條碼掃描結果。
// 2019/08/20 修改 ToArray() 方法，使程式更為簡潔。
namespace ETC2019.Models
{
    public class DataModel
    {
        public DateTime CreateDT { get; set; }
        public DateTime ModifyDT { get; set; }
        public Data[] Items { get; set; }
        public string Filename { get; set; }
        public string FirstID { get; set; }
        public Dictionary<string, Data> Pairs
        {
            get
            {
                Dictionary<string, Data> pairs = new Dictionary<string, Data>();
                
                for (int i = 0; i < Items.Length; i++)
                    pairs.Add(Items[i].ID, Items[i]);

                return pairs;
            }
        }

        public string[] ToArray()
        {
            return (from i in Items select i.ToString()).ToArray();
        }

        public override string ToString()
        {
            return Path.GetFileNameWithoutExtension(Filename);
        }

        public void Save(string path, string name)
        {
            using (StreamWriter sw = new StreamWriter(Path.Combine(path, name)))
            {
                sw.Write(JsonConvert.SerializeObject(this, Formatting.Indented));

                sw.Flush();

                sw.Close();
            }
        }
    }
}
