﻿using System;
using System.Collections.Generic;
using System.Data;
using System.Data.SqlClient;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using Newtonsoft.Json;
// Program:
//   資料庫連接參數。
// History:
// 2019/08/20 決定參數。
// 2019/08/29 新增移除方法。
namespace ETC2019.Models
{
    public class SQL
    {
        //public string DataSource { get; set; }
        //public string InitialCatalog { get; set; }
        //public string UserID { get; set; }
        //public string Password { get; set; }
        public string Table { get; set; }
        public string Columns { get; set; }
        public string OrderBy { get; set; }
        [JsonIgnore]
        private string ConnectionString
        {
            get
            {
                SqlConnectionStringBuilder builder = new SqlConnectionStringBuilder()
                {
                    DataSource = "192.168.6.233",
                    InitialCatalog = "nhpb",
                    UserID = "etc_mark",
                    Password = "2gi_4[B&PvJ9",
                };
                return builder.ConnectionString;
            }
        }

        public DataRowCollection Select(bool order)
        {
            string select = order ? "SELECT {0} FROM {1} ORDER BY {2} DESC" : "SELECT {0} FROM {1}";

            if (DataAdapter(string.Format(select, Columns, Table, OrderBy), out DataTable table))
            {
                if (order && string.IsNullOrEmpty(OrderBy))
                {
                    DataView dv = table.DefaultView;

                    dv.Sort = OrderBy;

                    return dv.ToTable().Rows;
                }
                else
                    return table.Rows;
            }
            else
                return new DataTable().Rows;
        }

        public DataRowCollection Select(bool order, string whereKey, string[] where)
        {
            string select = order ? "SELECT {0} FROM {1} WHERE {2} ORDER BY {3} DESC" : "SELECT {0} FROM {1} WHERE {2}";

            string whereQuery = where.Length > 0 ? string.Format("{0}='{1}'", whereKey, where[0]) : string.Empty;

            for (int i = 1; i < where.Length; i++)
                whereQuery = whereQuery + string.Format(" OR {0}='{1}'", whereKey, where[i]);

            return DataAdapter(string.Format(select, Columns, Table, whereQuery, OrderBy), out DataTable table) ? table.Rows : new DataTable().Rows;
        }

        public DataRowCollection SelectLike(bool order, string whereKey, string where)
        {
            string select = order ? "SELECT {0} FROM {1} WHERE {2} ORDER BY {3} DESC" : "SELECT {0} FROM {1} WHERE {2}";

            string whereQuery = where.Length > 0 ? string.Format("{0} LIKE '{1}'", whereKey, where) : string.Empty;

            return DataAdapter(string.Format(select, Columns, Table, whereQuery, OrderBy), out DataTable table) ? table.Rows : new DataTable().Rows;
        }

        public DataRowCollection SelectAnd(bool order, Dictionary<string, string> where)
        {
            string select = order ? "SELECT {0} FROM {1} WHERE {2} ORDER BY {3} DESC" : "SELECT {0} FROM {1} WHERE {2}";

            string whereQuery = string.Empty;
            
            foreach (string key in where.Keys)
                whereQuery = (string.IsNullOrEmpty(whereQuery)
                    ? string.Format("{0}='{1}'", key, where[key])
                    : string.Format("{0} AND {1}='{2}'", whereQuery, key, where[key]));

            return DataAdapter(string.Format(select, Columns, Table, whereQuery, OrderBy), out DataTable table) ? table.Rows : new DataTable().Rows;
        }

        public bool Insert(List<string[]> values)
        {
            string valueQuery = string.Empty, tempQuery = string.Empty;

            for (int i = 0; i < values.Count; i++)
            {
                for (int j = 0; j < values[i].Length; j++)
                    tempQuery = tempQuery == string.Empty ? string.Format("'{0}'", values[i][j]) : string.Format("{0},'{1}'", tempQuery, values[i][j]);

                valueQuery = valueQuery == string.Empty ? string.Format("({0})", tempQuery) : string.Format("{0},({1})", valueQuery, tempQuery);

                tempQuery = string.Empty;
            }

            return DataAdapter(string.Format("INSERT INTO {0} ({1}) VALUES {2}", Table, Columns, valueQuery));
        }

        public bool Insert(string[] value)
        {
            string valueQuery = string.Empty;

            for (int i = 0; i < value.Length; i++)
                valueQuery = valueQuery == string.Empty ? string.Format("'{0}'", value[i]) : string.Format("{0},'{1}'", valueQuery, value[i]);

            return DataAdapter(string.Format("INSERT INTO {0} ({1}) VALUES ({2})", Table, Columns, valueQuery));
        }

        public bool Delete(string whereKey, string[] where)
        {
            string whereQuery = where.Length > 0 ? string.Format("{0}='{1}'", whereKey, where[0]) : string.Empty;

            for (int i = 1; i < where.Length; i++)
                whereQuery = whereQuery + string.Format(" OR {0}='{1}'", whereKey, where[i]);

            return DataAdapter(string.Format("DELETE FROM {0} WHERE {1}", Table, whereQuery));
        }
        /*
         * UPDATE "表格名"
            SET "欄位1" = [新值]
            WHERE "條件";
         */
        public bool Update(string updateKey, string update, string whereKey, string where)
        {
            if (!string.IsNullOrEmpty(update) && !string.IsNullOrEmpty(where))
            {
                string updateQuery = string.Format("{0}='{1}'", updateKey, update);

                string whereQuery = string.Format("{0}='{1}'", whereKey, where);

                return DataAdapter(string.Format("UPDATE {0} SET {1} WHERE {2}", Table, updateQuery, whereQuery));
            }
            else
                return false;
        }

        private bool DataAdapter(string cmd, out DataTable table)
        {
            using (SqlConnection db = new SqlConnection(ConnectionString))
            {
                db.Open();

                using (SqlDataAdapter query = new SqlDataAdapter(cmd, db))
                {
                    table = new DataTable();

                    query.Fill(table);

                    db.Close();
                }
            }
            return true;
        }

        private bool DataAdapter(string cmd)
        {
            try
            {
                using (SqlConnection db = new SqlConnection(ConnectionString))
                {
                    db.Open();

                    using (SqlCommand query = new SqlCommand(cmd, db))
                    {
                        query.ExecuteNonQuery();

                        db.Close();
                    }
                }

                return true;
            }
            catch (SqlException ex)
            {
                Console.WriteLine(ex.Message);
            }

            return false;
        }
    }
}
