﻿using ETC2019.Controllers;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.Linq;
using System.Text;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ETC2019.Views
{
    public partial class BarcodePage : Form
    {
        private BarcodeController Controller { get; set; }

        public BarcodePage()
        {
            InitializeComponent();

            Controller = new BarcodeController();

            Controller.MessageShow += Controller_MessageShow;

            toolStripComboBox2.Items.AddRange(Controller.Returns);

            //toolStripTextBox1.Text = "HT";

            toolStripTextBox1.Focus();

            toolStripTextBox2.Text = string.Format("{0}", 0).PadLeft(3, '0');

            toolStripTextBox3.Text = string.Format("{0}{1}", DateTime.Now.Year - 1911, DateTime.Now.ToString("MMdd"));

            Text = Controller.SystemText;

            dataGridView1.Font = new Font(toolStripLabel1.Font.FontFamily, 12);
        }

        private void Controller_MessageShow(string message)
        {
            MessageBox.Show(message);
        }

        private void ToolStrip1_Resize(object sender, EventArgs e)
        {
            int[] w = (from ToolStripItem item in toolStrip1.Items
                       where item is ToolStripLabel || item is ToolStripButton || item is ToolStripComboBox || item is ToolStripSeparator
                       select (item.Size.Width - item.Margin.Left - item.Margin.Right)).ToArray();

            int width = toolStrip1.Size.Width - toolStrip1.Padding.Left - toolStrip1.Padding.Right - w.Sum();

            toolStripTextBox1.Size = new Size(width / 4, toolStripTextBox1.Size.Height);

            toolStripTextBox2.Size = new Size(width / 4, toolStripTextBox2.Size.Height);

            toolStripTextBox3.Size = new Size(width / 4, toolStripTextBox3.Size.Height);

            toolStripTextBox4.Size = new Size(width / 4, toolStripTextBox4.Size.Height);
        }

        private void ToolStripTextBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter)
            {
                string[] book = Controller.SelectAll(string.Format("{0}%", toolStripTextBox1.Text), "bookno");

                int[] count = Controller.SelectCount(string.Format("{0}%", toolStripTextBox1.Text));

                dataGridView1.Rows.Clear();

                for (int i = 0; i < book.Length; i++)
                {
                    List<string> id = new List<string>(Controller.SelectAll(book[i], "tkt_no"));

                    Dictionary<string, object[]> items = new Dictionary<string, object[]>();

                    for (int j = 0; j < id.Count; j++)
                    {
                        Dictionary<string, string> item = Controller.Select(id[j], book[i]);

                        if (item.Count > 0)
                        {
                            items.Add(item["tkt_no"], new object[]
                            {
                                item["bookno"],
                                item["tkt_no"],
                                item.ContainsKey("rsn") ? item["rsn"] : "",
                                item.ContainsKey("r_date") ? item["r_date"] : "",
                                item.ContainsKey("寄存日") ? item["寄存日"] : "",
                                "刪除",
                                item.ContainsKey("冊頁號") ? item["冊頁號"] : "",
                                item.ContainsKey("車號") ? item["車號"] : "",
                                item.ContainsKey("車主") ? item["車主"] : "",
                                item.ContainsKey("車主區號") ? item["車主區號"] : "",
                                item.ContainsKey("車主地址") ? item["車主地址"] : "",
                                item.ContainsKey("駕駛") ? item["駕駛"] : "",
                                item.ContainsKey("駕駛區號") ? item["駕駛區號"] : "",
                                item.ContainsKey("駕駛地址") ? item["駕駛地址"] : "",
                                item.ContainsKey("應到案處所") ? item["應到案處所"] : "",
                                item.ContainsKey("舉發單位") ? item["舉發單位"] : "",
                            });
                        }
                    }

                    items = items.OrderByDescending(item => item.Key).ToDictionary(item => item.Key, item => item.Value);

                    foreach (string key in items.Keys)
                    {
                        dataGridView1.Rows.Insert(0, items[key]);
                    }
                }

                dataGridView1.Sort(dataGridView1.Columns[0], ListSortDirection.Descending);

                //dataGridView1.Sort(dataGridView1.Columns[1], ListSortDirection.Descending);

                if (dataGridView1.Rows.Count > 0)
                {
                    dataGridView1.ClearSelection();

                    dataGridView1.Rows[0].Selected = true;
                }

                toolStripTextBox2.Text = string.Format("{0}", count.Length > 0 ? count.Max(): 0).PadLeft(3, '0');

                toolStripTextBox4.Text = string.Empty;

                toolStripTextBox4.Focus();

                e.Handled = true;
            }
        }

        private void ToolStripTextBox4_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter)
            {
                Dictionary<string, object[]> items = new Dictionary<string, object[]>();

                List<string> id = new List<string>(Controller.Insert(Convert.ToString(toolStripComboBox1.SelectedIndex), toolStripComboBox2.SelectedItem, toolStripTextBox1.Text, toolStripTextBox3.Text, toolStripTextBox4.Text, out string book));

                int[] count = Controller.SelectCount(string.Format("{0}%", toolStripTextBox1.Text));

                id.Sort();

                for (int i = id.Count - 1; i > -1; i--)
                {
                    Dictionary<string, string> item = Controller.Select(id[i], book);

                    items.Add(item["tkt_no"], new object[]
                    {
                        item["bookno"],
                        item["tkt_no"],
                        item["rsn"],
                        item["r_date"],
                        item["寄存日"],
                        "刪除",
                        item["冊頁號"],
                        item["車號"],
                        item["車主"],
                        item["車主區號"],
                        item["車主地址"],
                        item["駕駛"],
                        item["駕駛區號"],
                        item["駕駛地址"],
                        item["應到案處所"],
                        item["舉發單位"],
                    });
                }

                items = items.OrderByDescending(item => item.Key).ToDictionary(item => item.Key, item => item.Value);

                foreach (string key in items.Keys)
                {
                    dataGridView1.Rows.Insert(0, items[key]);
                }

                dataGridView1.Sort(dataGridView1.Columns[0], ListSortDirection.Descending);

                //dataGridView1.Sort(dataGridView1.Columns[1], ListSortDirection.Descending);

                if (dataGridView1.Rows.Count > 0)
                {
                    dataGridView1.ClearSelection();

                    dataGridView1.Rows[0].Selected = true;
                }

                toolStripTextBox2.Text = string.Format("{0}", count.Length > 0 ? count.Max() : 0).PadLeft(3, '0');

                if (id.Count > 0)
                {
                    toolStripLabel6.ForeColor = SystemColors.ControlText;
                }
                else
                {
                    toolStripLabel6.ForeColor = Color.Red;

                    //MessageBox.Show(string.Format("查無單號 {0}", toolStripTextBox4.Text));
                }

                toolStripTextBox4.Text = string.Empty;

                toolStripTextBox4.Focus();

                e.Handled = true;
            }
        }

        private void DataGridView1_CellContentClick(object sender, DataGridViewCellEventArgs e)
        {
            if (e.ColumnIndex > -1 && dataGridView1.Columns[e.ColumnIndex] is DataGridViewButtonColumn && e.RowIndex > -1)
            {
                if (dataGridView1.Rows[e.RowIndex].Cells[e.ColumnIndex].Value as string == "刪除")
                {
                    string book = dataGridView1.Rows[e.RowIndex].Cells[0].Value as string;

                    DataGridViewRow[] row = (from DataGridViewRow temp in dataGridView1.Rows where temp.Cells[0].Value as string == book select temp).ToArray();

                    for (int i = 0; i < row.Length; i++)
                        if (Controller.Delete(row[i].Cells[0].Value as string))
                            dataGridView1.Rows.Remove(row[i]);

                    dataGridView1.Refresh();
                }
            }
        }

        private void DataGridView1_CellEndEdit(object sender, DataGridViewCellEventArgs e)
        {
            if (e.RowIndex > -1)
            {
                string book = dataGridView1.Rows[e.RowIndex].Cells[0].Value as string;

                string updateKey = dataGridView1.Columns[e.ColumnIndex].HeaderText;

                string update = dataGridView1.Rows[e.RowIndex].Cells[e.ColumnIndex].Value as string;

                Controller.Update(updateKey, update, book);

                //DataGridViewRow[] row = (from DataGridViewRow temp in dataGridView1.Rows where temp.Cells[0].Value as string == book select temp).ToArray();

                //for (int i = 0; i < row.Length; i++)
                //    if (Controller.Update(updateKey, update, row[i].Cells[1].Value as string))
                //        row[i].Cells[e.ColumnIndex].Value = update;

                dataGridView1.Refresh();
            }
        }

        private void BarcodePage_FormClosing(object sender, FormClosingEventArgs e)
        {
            Controller.Save();
        }

        private void ToolStripComboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (string.IsNullOrEmpty(toolStripTextBox1.Text))
                switch (toolStripComboBox1.SelectedIndex)
                {
                    //case 0:
                    //    toolStripTextBox1.Text = "HT";

                    //    break;
                    //case 1:
                    //    toolStripTextBox1.Text = "HC";

                    //    break;
                    //case 2:
                    //    toolStripTextBox1.Text = "HT";

                    //    break;
                    case 0:
                        toolStripTextBox1.Text = "HM";

                        break;
                    case 1:
                        toolStripTextBox1.Text = "HZ";

                        break;
                    case 2:
                        toolStripTextBox1.Text = "HM";

                        break;
                }
            else
                switch (toolStripComboBox1.SelectedIndex)
                {
                    //case 0:
                    //    toolStripTextBox1.Text = toolStripTextBox1.Text.Replace("HC", "HT");

                    //    break;
                    //case 1:
                    //    toolStripTextBox1.Text = toolStripTextBox1.Text.Replace("HT", "HC");

                    //    break;
                    //case 2:
                    //    toolStripTextBox1.Text = toolStripTextBox1.Text.Replace("HC", "HT");

                    //    break;
                    case 0:
                        toolStripTextBox1.Text = toolStripTextBox1.Text.Replace("HZ", "HM");

                        break;
                    case 1:
                        toolStripTextBox1.Text = toolStripTextBox1.Text.Replace("HM", "HZ");

                        break;
                    case 2:
                        toolStripTextBox1.Text = toolStripTextBox1.Text.Replace("HZ", "HM");

                        break;
                }
        }

        private void toolStripButton1_Click(object sender, EventArgs e)
        {

        }

        private void toolStripButton2_Click(object sender, EventArgs e)
        {

        }
    }
}
