﻿using ETC2019.Controllers;
using System;
using System.Collections.Generic;
using System.ComponentModel;
using System.Data;
using System.Drawing;
using System.IO;
using System.Linq;
using System.Text;
using System.Threading;
using System.Threading.Tasks;
using System.Windows.Forms;

namespace ETC2019.Views
{
    public partial class QRCodePage : Form
    {
        private QRCodeController Controller { get; set; }
        private int IDCount { get; set; }
        private int FinishedCount { get; set; }
        private bool OnShift { get; set; }
        public QRCodePage()
        {
            InitializeComponent();

            Controller = new QRCodeController();
            Controller.ExplorerProgressChanged += Controller_ExplorerProgressChanged;
            Controller.ExplorerRunWorkerCompleted += Controller_ExplorerRunWorkerCompleted;
            Controller.ScannerProgressChanged += Controller_ScannerProgressChanged;
            Controller.ScannerRunWorkerCompleted += Controller_ScannerRunWorkerCompleted;
            Controller.ReaderRunWorkerCompleted += Controller_ReaderRunWorkerCompleted;
            Controller.NoterProgressChanged += Controller_NoterProgressChanged;
            Controller.MessageShow += Controller_MessageShow;

            toolStripTextBox4.Text = string.Format("{0}{1}", DateTime.Now.Year - 1911, DateTime.Now.ToString("MMdd"));

            Text = Controller.SystemText;
        }

        private void Controller_MessageShow(string text, string caption, MessageBoxButtons buttons)
        {
            MessageBox.Show(text, caption, buttons);
        }

        private void ToolStrip1_Resize(object sender, EventArgs e)
        {
            int[] w = (from ToolStripItem item in toolStrip1.Items
                       where item is ToolStripLabel || item is ToolStripButton || item is ToolStripComboBox || item is ToolStripSeparator
                       select (item.Size.Width - item.Margin.Left - item.Margin.Right)).ToArray();

            int width = toolStrip1.Size.Width - toolStrip1.Padding.Left - toolStrip1.Padding.Right - w.Sum();

            toolStripTextBox1.Size = new Size(width * 3 / 6, toolStripTextBox1.Size.Height);

            toolStripTextBox2.Size = new Size(width / 6, toolStripTextBox2.Size.Height);

            toolStripTextBox3.Size = new Size(width / 6, toolStripTextBox3.Size.Height);

            toolStripTextBox4.Size = new Size(width / 6, toolStripTextBox4.Size.Height);
        }

        private void Controller_ExplorerProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            toolStripStatusLabel2.Text = string.Format("{0}", e.UserState);
        }

        private void Controller_ExplorerRunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            
        }

        private void ToolStripButton1_Click(object sender, EventArgs e)
        {
            toolStripTextBox1.Text = Controller.Explore();
        }

        private void ToolStripTextBox2_TextChanged(object sender, EventArgs e)
        {
            Controller.BookID = toolStripTextBox2.Text;
        }

        private void ToolStripButton2_Click(object sender, EventArgs e)
        {
            toolStripComboBox1.Items.Clear();

            toolStripComboBox1.Items.AddRange(Controller.Returns);

            Controller.Scan(pictureBox1.Size.Width, pictureBox1.Size.Height, out Bitmap frontImage);

            pictureBox1.Image = frontImage;

            listBox1.SelectionMode = SelectionMode.One;

            listBox2.Items.Clear();

            listBox3.Items.Clear();

            listBox4.Items.Clear();
        }

        private void Controller_ScannerProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            if (e.UserState is int[])
            {
                int success = (e.UserState as int[])[1], failed = (e.UserState as int[])[2];
                toolStripStatusLabel4.Text = string.Format("{0}", IDCount = (e.UserState as int[])[0]);
                toolStripStatusLabel10.Text = string.Format("{0}", success);
                toolStripStatusLabel11.Text = string.Format("{0}", failed);
                toolStripStatusLabel16.Text = string.Format("{0}", Math.Round(Convert.ToDouble(success) * 10000 / (success + failed)) / 100);
            }
            else if (e.UserState is string)
                listBox1.Items.Add(e.UserState as string);
            else if (e.UserState is KeyValuePair<string, bool>)
            {
                KeyValuePair<string, bool> pair = (KeyValuePair<string, bool>)e.UserState;

                if (pair.Value)
                    listBox1.Items.Add(pair.Key);
                else
                    listBox2.Items.Add(pair.Key);
            }
            else if (e.UserState is TimeSpan)
            {
                TimeSpan ts = (TimeSpan)e.UserState;

                int s = Convert.ToInt32(Math.Round(ts.TotalSeconds * 100));

                int m = Convert.ToInt32(Math.Floor((double)s / 6000));

                toolStripStatusLabel14.Text = m > 0 ? string.Format("{0}分{1}秒", m, s / 100 - m * 60) : string.Format("{0}秒", s / 100);
            }
            listBox1.SelectedIndex = listBox1.Items.Count - 1;
        }

        private void Controller_ScannerRunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            listBox1.SelectionMode = listBox2.Items.Count > 0 ? SelectionMode.One : SelectionMode.MultiExtended;

            listBox2.SelectedIndex = listBox2.Items.Count > 0 ? 0 : -1;
        }

        private void ListBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listBox1.SelectedIndex > -1)
            {
                listBox4.Items.Clear();

                foreach (object item in listBox1.SelectedItems)
                {
                    string[] items = Controller.Read(item as string);
                    groupBox4.Text = "單號清單";
                    listBox4.Items.AddRange(items);
                    listBox4.Font = new Font(listBox4.Font.FontFamily, 36);
                }

                //Controller.Read(listBox1.SelectedItem as string);

                //listBox2.SelectedIndex = -1;

                //listBox3.SelectedIndex = -1;

                //listBox4.SelectedIndex = -1;
            }
        }

        private void ListBox2_SelectedIndexChanged_1(object sender, EventArgs e)
        {
            if (listBox2.Items.Count > 0)
            {
                if (listBox2.SelectedIndex > -1)
                {
                    //listBox4.Items.Clear();

                    //listBox4.Items.AddRange(Controller.Read(listBox2.SelectedItem as string, out string firstID));

                    Controller.Read(listBox2.SelectedItem as string, out string firstID);

                    listBox1.SelectedIndex = -1;

                    listBox3.SelectedIndex = -1;

                    listBox4.SelectedIndex = -1;

                    toolStripTextBox3.Text = firstID;

                    toolStripTextBox3.Focus();
                }
                listBox1.SelectionMode = SelectionMode.One;
            }
            else
                listBox1.SelectionMode = SelectionMode.MultiExtended;
        }

        private void listBox3_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listBox3.SelectedIndex > -1)
            {
                //    listBox4.Items.Clear();

                //    foreach (object item in listBox3.SelectedItems)
                //    {
                //        string[] items = Controller.Read(item as string);

                //        listBox4.Items.AddRange(items);
                //    }
                Controller.Read(listBox3.SelectedItem as string);
            }
        
        }

        private void Controller_ReaderRunWorkerCompleted(object sender, RunWorkerCompletedEventArgs e)
        {
            pictureBox1.BackgroundImage = e.Result as Bitmap;
        }

        private void ToolStripButton3_Click(object sender, EventArgs e)
        {
            if (toolStripTextBox3.Text.Length == 9)
            {
                if (listBox2.SelectedIndex > -1)
                {
                    object id = listBox2.SelectedItem;

                    int tempCount = 0;

                    if ((tempCount = Controller.Find(id as string, toolStripTextBox3.Text.ToUpper())) > 0)
                    {
                        listBox2.Items.Remove(id);

                        listBox1.Items.Insert(Controller.Locate(id as string, (from object temp in listBox1.Items select temp as string).ToArray()), id);

                        listBox2.SelectedIndex = listBox2.Items.Count > 0 ? 0 : -1;

                        toolStripStatusLabel4.Text = string.Format("{0}", IDCount += tempCount);
                    }
                }

                //if (listBox3.SelectedIndex > -1)
                //{
                //    object id = listBox3.SelectedItem;

                //    int tempCount = 0;

                //    if ((tempCount = Controller.Find(id as string, toolStripTextBox3.Text.ToUpper())) > 0)
                //    {
                //        listBox3.SelectedIndex = listBox3.Items.Count > listBox3.SelectedIndex + 1 ? listBox3.SelectedIndex + 1 : listBox3.SelectedIndex;

                //        toolStripStatusLabel4.Text = string.Format("{0}", IDCount += tempCount);
                //    }
                //}
            }
        }

        private void ToolStripTextBox3_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (char)Keys.Enter && toolStripTextBox3.Text.Length == 9)
            {
                object id = listBox2.SelectedItem;

                int tempCount = 0;

                if ((tempCount = Controller.Find(id as string, toolStripTextBox3.Text.ToUpper())) > 0)
                {
                    listBox2.Items.Remove(id);

                    listBox1.Items.Insert(Controller.Locate(id as string, (from object temp in listBox1.Items select temp as string).ToArray()), id);

                    listBox2.SelectedIndex = listBox2.Items.Count > 0 ? 0 : -1;

                    toolStripStatusLabel4.Text = string.Format("{0}", IDCount += tempCount);
                }

                e.Handled = true;
            }
            else if (!char.IsLetterOrDigit(e.KeyChar) && e.KeyChar != (char)Keys.Delete && e.KeyChar != (char)Keys.Back)
                e.Handled = true;
        }

        private void ToolStripButton4_Click(object sender, EventArgs e)
        {
            listBox3.SelectedIndex = -1;

            Controller.Note((from object item in listBox3.Items select item).ToArray());
        }

        private void Controller_NoterProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            if (e.UserState is int)
            {
                FinishedCount = FinishedCount + Convert.ToInt32(e.UserState);

                toolStripStatusLabel6.Text = Convert.ToString(FinishedCount);

                toolStripStatusLabel8.Text = Convert.ToString(Controller.Count - FinishedCount);
            }

            if (e.UserState is KeyValuePair<string, bool>)
            {
                KeyValuePair<string, bool> pair = (KeyValuePair<string, bool>)e.UserState;

                listBox3.Items.Remove(pair.Key);

                if (pair.Value)
                    listBox4.Items.Add(pair.Key);
                else
                    listBox2.Items.Add(pair.Key);
            }
        }

        private void ToolStripComboBox1_SelectedIndexChanged(object sender, EventArgs e)
        {
            Controller.ReturnID = toolStripComboBox1.SelectedItem;
        }

        private void ToolStripTextBox4_TextChanged(object sender, EventArgs e)
        {
            if (toolStripTextBox4.Text.Length == 7)
            {
                int dy = int.TryParse(toolStripTextBox4.Text.Substring(0, 3), out int year) ? year + 1911 : 0;

                int dm = int.TryParse(toolStripTextBox4.Text.Substring(3, 2), out int month) ? month : 0;

                int dd = int.TryParse(toolStripTextBox4.Text.Substring(5, 2), out int day) ? day : 0;

                //toolStripTextBox4.Text = Controller.DepositDT = Convert.ToString(year) + Convert.ToString(month).PadLeft(2, '0') + Convert.ToString(day).PadLeft(2, '0');

                Controller.DepositDT = toolStripTextBox4.Text;
            }
        }

        private void QRCodePage_FormClosing(object sender, FormClosingEventArgs e)
        {
            Controller.Save();
        }

        private void ListBox1_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (!backgroundWorker1.IsBusy)
            {
                if (e.KeyChar == (int)Keys.Enter && OnShift)
                {
                    object[] list1 = (from object item in listBox1.Items select item).ToArray();

                    object[] list2 = new object[listBox3.Items.Count];

                    for (int i = 0; i < listBox3.Items.Count; i++)
                        list2[i] = listBox3.Items[i];

                    listBox3.Items.Clear();

                    listBox3.Items.AddRange(Controller.Locate(list1, list2));

                    foreach (object item in list1)
                        listBox1.Items.Remove(item);
                }
                else if (e.KeyChar == (int)Keys.Enter)
                {
                    object[] list1 = (from object item in listBox1.SelectedItems select item).ToArray();

                    object[] list2 = new object[listBox3.Items.Count];

                    for (int i = 0; i < listBox3.Items.Count; i++)
                        list2[i] = listBox3.Items[i];

                    listBox3.Items.Clear();

                    listBox3.Items.AddRange(Controller.Locate(list1, list2));

                    foreach (object item in list1)
                        listBox1.Items.Remove(item);
                }
            }
        }

        private void listBox3_KeyPress(object sender, KeyPressEventArgs e)
        {
            if (e.KeyChar == (int)Keys.Enter && OnShift)
            {
                object[] list1 = (from object item in listBox3.Items select item).ToArray();

                object[] list2 = new object[listBox1.Items.Count];

                for (int i = 0; i < listBox1.Items.Count; i++)
                    list2[i] = listBox1.Items[i];

                listBox1.Items.Clear();

                listBox1.Items.AddRange(Controller.Locate(list1, list2));

                foreach (object item in list1)
                    listBox3.Items.Remove(item);
            }
            else if (e.KeyChar == (int)Keys.Enter)
            {
                object[] list1 = (from object item in listBox3.SelectedItems select item).ToArray();

                object[] list2 = new object[listBox1.Items.Count];

                for (int i = 0; i < listBox1.Items.Count; i++)
                    list2[i] = listBox1.Items[i];

                listBox1.Items.Clear();

                listBox1.Items.AddRange(Controller.Locate(list1, list2));

                foreach (object item in list1)
                    listBox3.Items.Remove(item);
            }
        }

        private void ListBox2_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listBox2.SelectedIndex > -1)
            {
                Controller.Read(listBox3.SelectedItem as string);

                listBox1.SelectedIndex = -1;
            }
        }

        private void ToolStripTextBox4_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = !char.IsDigit(e.KeyChar) && e.KeyChar != (char)Keys.Delete && e.KeyChar != (char)Keys.Back;
        }

        private void ToolStripTextBox2_KeyPress(object sender, KeyPressEventArgs e)
        {
            e.Handled = !char.IsLetterOrDigit(e.KeyChar) && e.KeyChar != (char)Keys.Delete && e.KeyChar != (char)Keys.Back;
        }

        private void ListBox1_KeyDown(object sender, KeyEventArgs e)
        {
            OnShift = e.Shift;
        }

        private void ListBox1_KeyUp(object sender, KeyEventArgs e)
        {
            OnShift = e.Shift;
        }

        private void BackgroundWorker1_DoWork(object sender, DoWorkEventArgs e)
        {
            object[] items = e.Argument as object[];

            foreach (object item in items)
            {
                backgroundWorker1.ReportProgress(0, item);

                Thread.Sleep(10);
            }
        }

        private void BackgroundWorker1_ProgressChanged(object sender, ProgressChangedEventArgs e)
        {
            listBox1.Items.Remove(e.UserState);

            listBox3.Items.Insert(Controller.Locate(e.UserState as string, (from object temp in listBox3.Items select temp as string).ToArray()), e.UserState);
        }

        private void ListBox3_KeyDown(object sender, KeyEventArgs e)
        {
            OnShift = e.Shift;
        }

        private void ListBox3_KeyUp(object sender, KeyEventArgs e)
        {
            OnShift = e.Shift;
        }

        private void ToolStripTextBox1_TextChanged(object sender, EventArgs e)
        {
            toolStripTextBox2.Text = Controller.BookID = Path.GetFileNameWithoutExtension(toolStripTextBox1.Text);

            toolStripComboBox1.Items.Clear();

            listBox1.Items.Clear();

            listBox2.Items.Clear();

            listBox3.Items.Clear();

            listBox4.Items.Clear();

            FinishedCount = 0;
        }

        private void ListBox4_SelectedIndexChanged(object sender, EventArgs e)
        {
            if (listBox4.SelectedIndex > -1)
            {
                //listBox4.Items.Clear();

                //foreach (object item in listBox1.SelectedItems)
                //{
                //    string[] items = Controller.Read(item as string);

                //    listBox4.Items.AddRange(items);
                //}

                Controller.Read(listBox4.SelectedItem as string);

                listBox1.SelectedIndex = -1;

                listBox2.SelectedIndex = -1;

                listBox3.SelectedIndex = -1;
            }
        }
    }
}
