import json, os, socket, time, subprocess as SP
from paho.mqtt.client import Client as MQTT

def TryConnect(host, port):
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        s.connect((host, int(port)))
        s.shutdown(socket.SHUT_RDWR)
        return True
    except ConnectionRefusedError:
        print("Connect to {0}:{1} is refused.".format(host, port))
    except:
        print("Error with unknown problem.")
    return False
    
user = os.getenv("DVR_USER") or "admin"
    
pswd = os.getenv("DVR_PSWD") or "ecom2828"

name = os.getenv("DVR_NAME") or "rd"

key = os.getenv("DVR_KEY") or "main_4"

topic = "dvr/{0}/{1}".format(name, key)

payload = { 'status': 0, 'host': "", 'name': name, 'key': key, 'msg': "" }

while True:
    host = os.getenv("MQTT_HOST") or "192.168.5.217"

    port = os.getenv("MQTT_PORT") or "1883"
    
    print("Connect to MQTT")
    
    if TryConnect(host, port): # 測試連線到 MQTT
        client = MQTT()

        client.connect(host, int(port), 3600)

        host = os.getenv("ED_HOST") or "192.168.5.208"

        port = os.getenv("ED_PORT") or "554"
        
        if TryConnect(host, port): # 測試連線到 EasyDarwin
            payload['host'] = host
            
            rtsp_out = "rtsp://{0}:{1}".format(host, port)

            host = os.getenv("DVR_HOST") or "192.168.5.198"

            port = os.getenv("DVR_PORT") or "80"
            
            if TryConnect(host, port): # 測試連線到 DVR
                rtsp_out = "{0}/{1}/{2}".format(rtsp_out, name, key)
                
                rtsp_in = "rtsp://{0}:{1}@{2}".format(user, pswd, host)
                
                rtsp_in = rtsp_in if port == "80" else "{0}:{1}".format(rtsp_in, port)
                
                rtsp_in = "{0}/{1}".format(rtsp_in, key)
   
                p = SP.Popen([
                    'ffmpeg',                 # DVR to EasyDarwin
                    '-rtsp_transport', 'tcp', # 指定來源協定
                    '-i', rtsp_in,            # 指定來源路徑
                    '-c:v', 'copy',           # 指定輸出影像編碼
                    '-an',                    # 指定輸出聲音編碼 (an: 無聲音)
                    '-rtsp_transport', 'tcp', # 指定輸出協定
                    '-f','rtsp', rtsp_out,    # 指定輸出格式與路徑
                ])
                
                try:
                    payload['status'] = 1
                    
                    payload['msg'] = 'Ready to Transfer.'
                    
                    client.publish(topic, json.dumps(payload), 1)
                    
                    p.communicate()
                    
                    payload['status'] = 0
                    
                    payload['msg'] = 'Popen is closed.'
                    
                    client.publish(topic, json.dumps(payload), 1)
                except Exception as e:
                    payload['status'] = 0
                    
                    payload['msg'] = e
                    
                    client.publish(topic, json.dumps(payload), 1)
            else:
                payload['msg'] =  "Connect to DVR is refused."

                payload['status'] = 0

                client.publish(topic, json.dumps(payload), 1)
        else:
            payload['msg'] =  "Connect to EasyDarwin is refused."

            payload['status'] = 0

            client.publish(topic, json.dumps(payload), 1)
    else:
        print("Connect to MQTT is refused.")