import paho.mqtt.client as mqtt, os, json, requests

def on_connect(client, userdata, flags, rc):
    # client: the client instance for this callback
    # userdata: the private user data as set in Client()
    # flags: response flags sent by the broker
    # rc: the connection result
    client.subscribe("dvr/#") # DVR
    
def on_message(client, userdata, msg):
    payload = json.loads(str(msg.payload.decode()))
    
    host = os.getenv("API_HOST") or "192.168.5.217"
    
    port = os.getenv("API_PORT") or "8001"
    
    data = {
        'account': os.getenv("API_USER") or "admin",
        'password': os.getenv("API_PSWD") or "qL8oAGg8",
    }
    
    user = requests.post('http://{0}:{1}/login'.format(host, port), data=data)
    
    if user.status_code == requests.codes.ok:
        user = json.loads(user.text)
        
        if 'dvr' in msg.topic and payload['status'] == 1:
            url = 'http://{0}:{1}/{2}/insert/stream'.format(host, port, user['EndPoint'])
            
            headers = { 'Authorization': 'Bearer {0}'.format(user['AccessToken']) }
            
            data = {
                'host': payload['host'],
                'name': payload['name'],
                'ch': payload['ch'],
            }
            
            stream = requests.post(url, headers=headers, data=data)
            
            stream = json.loads(stream.text)
            
            print(stream)
        else:
            print("Do Something")
    else:
        print(user.status_code)
        
host = os.getenv("MQTT_HOST") or "192.168.5.217"

port = os.getenv("MQTT_PORT") or "1883"

client = mqtt.Client()

client.on_connect = on_connect

client.on_message = on_message

client.connect(host, int(port), 3600)

client.loop_forever()