import json, os, socket, time, subprocess as SP
from paho.mqtt.client import Client as MQTT

def TryConnect(host, port):
    s = socket.socket(socket.AF_INET, socket.SOCK_STREAM)
    try:
        s.connect((host, int(port)))
        s.shutdown(socket.SHUT_RDWR)
        return True
    except ConnectionRefusedError:
        print("Connect to {0}:{1} is refused.".format(host, port))
    except:
        print("Error with unknown problem.")
    return False
    
user = os.getenv("DVR_USER")
    
pswd = os.getenv("DVR_PSWD")

name = os.getenv("DVR_NAME")

key = os.getenv("DVR_KEY")

ch = os.getenv("ED_CH")

topic = "dvr/{0}/{1}".format(name, ch)

while True:
    payload = { 'status': 0, 'host': "", 'name': "", 'ch': "", 'msg': "" }
    
    host = os.getenv("MQTT_HOST")

    port = os.getenv("MQTT_PORT")
    
    print("Connect to MQTT")
    
    if TryConnect(host, port): # 測試連線到 MQTT
        client = MQTT()

        client.connect(host, int(port), 3600)

        host = os.getenv("ED_HOST")

        port = os.getenv("ED_PORT")

        if TryConnect(host, port): # 測試連線到 EasyDarwin
            payload['host'] = host

            rtsp_out = "rtsp://{0}:{1}".format(host, port)

            host = os.getenv("DVR_HOST")

            port = os.getenv("DVR_PORT")
            
            if TryConnect(host, port): # 測試連線到 DVR
                payload['name'] = name
                
                payload['ch'] = ch
                
                rtsp_out = "{0}/{1}/{2}".format(rtsp_out, name, ch)
                
                if user == None or pswd == None:
                    rtsp_in = "rtsp://{0}".format(host)
                else:
                    rtsp_in = "rtsp://{0}:{1}@{2}".format(user, pswd, host)
                
                rtsp_in = rtsp_in if port == "80" else "{0}:{1}".format(rtsp_in, port)
                
                rtsp_in = "{0}/{1}".format(rtsp_in, key)
   
                p = SP.Popen([
                    'ffmpeg',                 # DVR to EasyDarwin
                    '-rtsp_transport', 'tcp', # 指定來源協定
                    '-i', rtsp_in,            # 指定來源路徑
                    '-c:v', 'copy',           # 指定輸出影像編碼
                    '-an',                    # 指定輸出聲音編碼 (an: 無聲音)
                    '-rtsp_transport', 'tcp', # 指定輸出協定
                    '-f','rtsp', rtsp_out,    # 指定輸出格式與路徑
                ])
                
                try:
                    payload['status'] = 1
                    
                    payload['msg'] = "Ready to Transfer."

                    client.publish(topic, json.dumps(payload), 1)
                    
                    p.communicate()

                    payload['status'] = 0
                    
                    payload['msg'] = "Popen is closed."
                    
                    client.publish(topic, json.dumps(payload), 1)
                except Exception as e:
                    payload['status'] = 0
                    
                    payload['msg'] = e
                    
                    client.publish(topic, json.dumps(payload), 1)
            else:
                payload['status'] = 0
                
                payload['msg'] =  "Connect to DVR is refused."

                client.publish(topic, json.dumps(payload), 1)
        else:
            payload['status'] = 0
            
            payload['msg'] =  "Connect to EasyDarwin is refused."

            client.publish(topic, json.dumps(payload), 1)
    else:
        print("Connect to MQTT is refused.")