import paho.mqtt.client as mqtt, subprocess as sp, os, time, json

topic = os.getenv('DVR_TAG') + "/" + os.getenv('SRS_CH')

rtsp = "rtsp://" + os.getenv('DVR_USER') + ":" + os.getenv('DVR_PSWD') # DVR 使用者認證

rtsp = rtsp + "@" + os.getenv('DVR_HOST') # DVR 位址

rtsp = rtsp + "/" + os.getenv('DVR_TYPE') + "_" + os.getenv('DVR_CH') # DVR 串流

rtmp = "rtmp://" + os.getenv('SRS_HOST') + ":" + os.getenv('SRS_PORT') # SRS 位址

rtmp = rtmp + "/live/" + topic # SRS 串流

cmd = [
	'ffmpeg', '-rtsp_transport', 'tcp', # RTSP to RTMP 轉發
	'-i', rtsp, # DVR 連結
	'-c:v', 'copy', # 相同影像格式
	'-an', # 無聲音
	'-f', 'flv', rtmp, # SRS 連結
]

# client = mqtt.Client(client_id=os.getenv('DVR_TAG'))

# client.connect(os.getenv('MQTT'))

# data = { 'status' : 0, 'rtsp' : rtsp, 'rtmp' : rtmp }

while True:
    p = sp.Popen(cmd, stderr=sp.PIPE)
    
    while p.returncode == None:
        t = time.strftime("[%Y/%m/%d][%H:%M:%S][" + str(p.pid) + "]")

        if not p.stderr.isatty():

            err = p.stderr.readline()

            err = str(err, encoding='utf-8') if len(err) > 0 else ""

            index1 = (err.index("'") + 1) if "'" in err else 0

            index2 = (err.index("'", index1)) if "'" in err else 0

            if 'Input' in err and index2 > index1:
                print(t + " > I: " + err[index1:index2])

            if 'Output' in err and index2 > index1:
                print(t + " > O: " + err[index1:index2])

            p.stderr.flush()
            
        else:
            
            print(t)

        time.sleep(1)

while False:
	p = sp.Popen(cmd)

	while p.returncode == None:
		data['status'] = 1
		
		time.sleep(os.getenv('INTERVAL'))

	data['status'] = 0