@extends('layouts.template')

@section('content')

<div class="thumbnail">
    <div class="row justify-content-center">
        <form class="col-6" id="send" action="/attend" method="POST">
            {{ csrf_field() }}      
            <!-- 姓名 開始結束時間input -->
                <div class="form-group row">
                    <label for="text" class="col-sm-2 col-form-label">姓名</label>
                    <div class="col-sm-10">
                        <div class="input-group date" data-target-input="nearest">
                            <input type="text" class="form-control" id="people" name="people" value="">
                            <div class="input-group-append" class="dropdown-toggle" data-toggle="dropdown">
                                <div class="input-group-text" id="btnGetDetails"><i class="fa fa-user fa-lg"></i></div>
                                <ul id="target" class="dropdown-menu">
                                @foreach($content as $contents)
                                    <li class="nav-item">
                                    <a class="nav-link text-dark">{{$contents['name']}} </a>
                                    </li>
                                @endforeach
                                </ul> 
                            </div>     
                        </div>
                    </div>
                </div>

                <div class="form-group row" >
                    <label for="text" class="col-sm-2 col-form-label">開始時間</label>
                    <div class="col-sm-10">
                        <div class="input-group date" id="datetimepicker1" data-target-input="nearest">     
                            <input id="start_time" name="start_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker1" required="">
                            <div class="input-group-append" data-target="#datetimepicker1" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="form-group row" >
                    <label for="text" class="col-sm-2 col-form-label">結束時間</label>
                    <div class="col-sm-10">
                        <div class="input-group date" id="datetimepicker2" data-target-input="nearest">     
                            <input id="end_time" name="end_time" type="text" class="form-control datetimepicker-input" data-target="#datetimepicker2" required="">
                            <div class="input-group-append" data-target="#datetimepicker2" data-toggle="datetimepicker">
                                <div class="input-group-text"><i class="fa fa-calendar"></i></div>
                            </div>
                        </div>
                    </div>
                </div>

            <div style="text-align:center">
                <input id='sub_btn'  class="btn-lg btn-success btn" type="submit" value="送出"/>
            </div>
        </form>
    </div>
</div>  
    <input class="form-control" id="myInput" type="text" placeholder="Search..">
    <table  class="table table-dark table-striped " style="text-align:center">
        <tr>
            <td>時間</td>
            <td>姓名</td>
            <td>上班時間</td>
            <td>下班時間 </td>
            <td>外出時間</td>
            <td>返回時間</td>
        </tr>
        <tbody id="myTable">
            @foreach($content as $contents)
                <tr >
                    <td>{{$contents['time']}}</td>
                    <td>{{$contents['name']}}</td>
                    <td>{{$contents['on_work']}}</td>
                    <td>{{$contents['off_work']}}</td>
                    <td>{{$contents['go_out']}}</td>
                    <td>{{$contents['come_back']}}</td>
                </tr>
            @endforeach
        </tbody>
    </table>
<span id='buttom'></span>
    </div>
</div>





<!-- 時間選擇器 -->
<!-- datetimepicker1 物件  -->
<script type="text/javascript">
    $(function () {
        $('#datetimepicker1').datetimepicker({
            locale:'zh-tw',
            format: 'YYYY/MM/DD HH:mm:ss ',
            weekStart: 1,
            autoclose: 0,
            todayHighlight: 1,
            // sideBySide:true,
            stepping:0,
            minView:0,
            maxView:0,
            startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
        });
    });
</script>

<!-- datetimepicker2 物件  -->
<script type="text/javascript">
    $(function () {
        $('#datetimepicker2').datetimepicker({
            locale:'zh-tw',
            format: 'YYYY/MM/DD HH:mm:ss ',
            weekStart: 1,
            autoclose: 0,
            todayHighlight: 1,
            // sideBySide:true,
            stepping:0,
            minView:0,
            maxView:0,

            startView: 0,  // 0 ＝月曆   1＝月份  2 =年份
        });
    });
</script>

<script>

$(document).ready(function() 
{
   $('ul.dropdown-menu li').click(function(e) 
   { 
    $("#people").val($.trim($(this).text()));
    //trime => clear white spaces
   });
});

 $(document).ready(function(){
   $("#myInput").on("keyup", function() {
     var value = $(this).val().toLowerCase();
     $("#myTable tr").filter(function() {
       $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
     });
   });
 });
 </script>

@endsection

 
