<?php

namespace App\Http\Controllers;

use App\Path;
use App\Car;
use GuzzleHttp\Client;
use Illuminate\Support\Arr;
use Illuminate\Http\Request;

class DockerController extends Controller
{
    //

    private $docker_ip="http://192.168.43.203:2375";

    public function init()
    {
        $query = Path::all();
        $main=Car::all();
        $client = new \GuzzleHttp\Client();
        $res = $client->get($this->docker_ip."/containers/json?all=1");
        $response = json_decode($res->getBody()->__toString(), true);

        $container_count=count($response);
        $result_content=array();
        // dd($response[0]['Ports']);
        for($i=0;$i<$container_count;$i++){
            // $array = Arr::add('Id',$response[$i]['Id']);
            array_push($result_content,['Names'=>$response[$i]['Names'],'Id'=>substr($response[$i]['Id'],0,12),'Ports'=>$response[$i]['Ports'],
            'State'=>$response[$i]['State'],'Status'=>$response[$i]['Status'],
            'Created'=>$response[$i]['Created']]);
        }
        // dd($result_content);
        return View('index',['page' => 'service','result'=>$query,'iresult'=>$main,'contents'=>$result_content,'navbar_li'=>'layouts.navbar_li','title'=>'tt']);
    }
    public function test(Request $request){
        $status=$request->input('btn');
        $container_id=$request->input('id');
        
        $client = new \GuzzleHttp\Client();
        $res = $client->POST($this->docker_ip."/containers/".$container_id."/".$status);
        return redirect()->back();

    }
    public function create(Request $request){
        $rr=$request->input('origin_stream');
        $dd=$request->input('identify_module');
        // return($rr.$dd);

        $client = new \GuzzleHttp\Client();
        $res = $client->POST($this->docker_ip."/images/create?",[
            'fromImage' =>'busybox',
            'tag'       =>'latest'
        ]);
        $response = json_decode($res->getBody()->__toString(), true);
        return $response;
    }
}
