<?php

namespace App\Http\Controllers\Video;

use App\Camdb;
use App\CamType;
use App\CamGoup;
use App\Path;
use App\Car;
use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use function MongoDB\BSON\toJSON;

class CamdbController extends Controller
{

    public function config()
    {
        //
        $query = Path::all();
  
        $main=Car::all();
        $type_id=CamType::all('type_id');
        $goups=CamGoup::all();
        return view('video_replay.configcam',['title'=>'新增攝影機','Types'=>$type_id,'Goups'=>$goups,'result'=>$query,'iresult'=>$main]);
    }

    public function play()
    {
        //
        $query = Path::all();
  
        $main=Car::all();
        $goups=CamGoup::all();
        return view('video_replay.playrealtime',['Goups'=>$goups,'result'=>$query,'iresult'=>$main]);
    }


    public function create()
    {
        //
    }


    public function replay()
    {
        //
        $query = Path::all();
  
        $main=Car::all();
        $goups=CamGoup::all();
        return View('video_replay.replay',['Goups'=>$goups,'result'=>$query,'iresult'=>$main]);

    }

    public function record()
    {
        $query = Path::all();
  
        $main=Car::all();
        $goups=CamGoup::all();
        return view('video_replay.recordconfig',['Goups'=>$goups,'result'=>$query,'iresult'=>$main]);
    }
    public function find_channel($cam_id)
    {
        // $query = Path::all();
        // $car=Path_option::all();
        $Channel=Camdb::all('camera_id','camera_path')->where('camera_id',$cam_id);
        return $Channel;
    }
    public function get_info($cam_list)
    {
        $Cam_list=collect(Camdb::where('camera_id',$cam_list)->first());
        $Goup_name=collect(CamGoup::where('goup_id',$Cam_list['camera_goup'])->first());

        $info_list=$Cam_list->merge($Goup_name);

        return $info_list;

    }

    public function show_in_playrealtime($goup_id)
    {
        $Cam_list=Camdb::all('camera_id','camera_goup','camera_path','camera_startime')->where('camera_goup',$goup_id);
        return $Cam_list;
    }

    public function show_in_replay($goup_id)
    {
        //
        $Cam_list=Camdb::all('camera_id','camera_goup','camera_path','camera_startime')->where('camera_goup',$goup_id)->where('camera_startime','!=',null);
        return $Cam_list;

    }

    public function show_in_recordconfig($goup_id)
    {
        //
        $Cam_list=Camdb::all('camera_id','camera_goup','camera_path','camera_startime')->where('camera_goup',$goup_id);
        return $Cam_list;
    }

    public function edit(Camdb $camdb)
    {
        //
    }


    public function update(Request $request, Camdb $camdb)
    {
        //
    }

    public function destroy(Camdb $camdb)
    {
        //
    }
}
