<h2>Management all service</h2>
<p>Type something in the input field to search the table for first names, last names or emails:</p>  
<input class="form-control" id="myInput" type="text" placeholder="Search..">
<br>
<!-- <form method="post" action="{{route('api')}}"> -->
<table class="table table-bordered" id= "table-id" style="color:#fff">
    <thead>
        <tr>
            <th>Container</th>
            <th>State</th>
            <th>Published Ports</th>
            <th>Status</th>
            <th>Created</th>
            <th>P.S</th>
        </tr>
    </thead>
    <tbody id="myTable">
        @foreach($contents as $content)
            <tr>
                  <form method="post" action="{{route('api')}}">
                      <input type = "hidden" name = "_token" value = "<?php echo csrf_token(); ?>">  
                      <td>{{$content['Names'][0]}}</td>
                      <td>{{$content['State']}}</td>
                      @if(empty($content['Ports'][0]['PrivatePort']))
                          <td></td>
                      @else
                          <td>{{$content['Ports'][0]['PrivatePort']}}:
                          @if(empty($content['Ports'][0]['PublicPort']))
                          @else
                          {{$content['Ports'][0]['PublicPort']}}
                          @endif
                          </td>
                      @endif
                          <td>{{$content['Status']}}</td>
                      <td>{{date('Y-m-d H:i:s',$content['Created'])}}</td><!--timestamp to date-->
                      <td>
                          <input type = "hidden" name = "id" value = "{{$content['Id']}}">
                          <button type="submit" class="btn btn-Success" name="btn" value="start">啟動</button>
                          <button type="submit" class="btn btn-Danger" name="btn" value="stop">停止</button>
                          <button type="submit" class="btn btn-Primary" name="btn" value="restart">重啟</button>
                      </td>
                </form>
            </tr>
        @endforeach
    </tbody>
</table>
<!-- </form>-->
<div class="container" >
  <div class="form-group">
  <h3>每頁</h3> 	<!--		Show Numbers Of Rows 		-->
  <div class="col-sm-10">
    <select class="form-control" name="state" id="maxRows">
        <option value="5000">All</option>
        <option value="5">5</option>
        <option value="10">10</option>
        <option value="15">15</option>
        <option value="20">20</option>
        <option value="50">50</option>
      </select>
      </div>
      <h3>筆</h3> 
			  	
      <!--		Start Pagination -->
      <div class='pagination-container' style="text-align:right">
      <nav>
      <ul class="pagination page-item" >
      <li data-page="prev">
      <span style="border-top-left-radius: 5px;border-bottom-left-radius: 5px;"> < <span class="sr-only">(current)</span></span>
      </li>

      <li data-page="next" id="prev">
      <span style="border-top-right-radius: 5px;border-bottom-right-radius: 5px;"> > <span class="sr-only">(current)</span></span>
      </li>
      </ul>
      </nav>
      </div> <!--		end Pagination -->
        

    </div>
  </div> <!-- 		End of Container -->
<p>Note that we start the search in tbody, to prevent filtering the table headers.</p>

<script>
//search bar
$(document).ready(function(){
  $("#myInput").on("keyup", function() {
    var value = $(this).val().toLowerCase();
    $("#myTable tr").filter(function() {
      $(this).toggle($(this).text().toLowerCase().indexOf(value) > -1)
    });
  });
});
</script>
<script>
getPagination('#table-id');
	function getPagination (table){

var lastPage = 1 ; 

$('#maxRows').on('change',function(evt){
//$('.paginationprev').html('');						// reset pagination 


lastPage = 1 ; 
$('.pagination').find("li").slice(1, -1).remove();
var trnum = 0 ;									// reset tr counter 
var maxRows = parseInt($(this).val());			// get Max Rows from select option

if(maxRows == 5000 ){

  $('.pagination').hide();
}else {
  
  $('.pagination').show();
}

var totalRows = $(table+' tbody tr').length;		// numbers of rows 
$(table+' tr:gt(0)').each(function(){			// each TR in  table and not the header
 trnum++;									// Start Counter 
 if (trnum > maxRows ){						// if tr number gt maxRows
     
     $(this).hide();							// fade it out 
 }if (trnum <= maxRows ){$(this).show();}// else fade in Important in case if it ..
});											//  was fade out to fade it in 
if (totalRows > maxRows){						// if tr total rows gt max rows option
 var pagenum = Math.ceil(totalRows/maxRows);	// ceil total(rows/maxrows) to get ..  
                                             //	numbers of pages 
 for (var i = 1; i <= pagenum ;){			// for each page append pagination li 
 $('.pagination #prev').before('<li data-page="'+i+'">\
                      <span>'+ i++ +'<span class="sr-only">(current)</span></span>\
                    </li>').show();
 }											// end for i 
} 												// end if row count > max rows
$('.pagination [data-page="1"]').addClass('active'); // add active class to the first li 
$('.pagination li').on('click',function(evt){		// on click each page
evt.stopImmediatePropagation();
evt.preventDefault();
var pageNum = $(this).attr('data-page');	// get it's number

var maxRows = parseInt($('#maxRows').val());			// get Max Rows from select option

if(pageNum == "prev" ){
    if(lastPage == 1 ){return;}
    pageNum  = --lastPage ; 
}
if(pageNum == "next" ){
    if(lastPage == ($('.pagination li').length -2) ){return;}
    pageNum  = ++lastPage ; 
}

lastPage = pageNum ;
var trIndex = 0 ;							// reset tr counter
$('.pagination li').removeClass('active');	// remove active class from all li 
$('.pagination [data-page="'+lastPage+'"]').addClass('active');// add active class to the clicked 
// $(this).addClass('active');					// add active class to the clicked 
 $(table+' tr:gt(0)').each(function(){		// each tr in table not the header
     trIndex++;								// tr index counter 
     // if tr index gt maxRows*pageNum or lt maxRows*pageNum-maxRows fade if out
     if (trIndex > (maxRows*pageNum) || trIndex <= ((maxRows*pageNum)-maxRows)){
         $(this).hide();		
     }else {$(this).show();} 				//else fade in 
 }); 										// end of for each tr in table
    });										// end of on click pagination list

}).val(5).change();

                                // end of on select change 
                // END OF PAGINATION 
}	
</script>