<?php

/*
|--------------------------------------------------------------------------
| Web Routes
|--------------------------------------------------------------------------
|
| Here is where you can register web routes for your application. These
| routes are loaded by the RouteServiceProvider within a group which
| contains the "web" middleware group. Now create something great!
|
*/

use Illuminate\Auth\Middleware\Authenticate ;
Route::get('/','PageController@page')->name('/');
Route::get('page','PageController@page');
Route::get('health','PageController@health');
Route::get('car_sys','PageController@car_sys');
Route::get('video_replay','PageController@video_replay');

Route::get('smart_parking','Parking\IndexController@index');

Route::get('attendance','AttendanceController@atten');
Route::post('attend','AttendanceController@attend');
Route::post('user','AttendanceController@user');
Route::get('line','PageController@line');

Route::get('test','PageController@test');
// Route::get('HRM','PageController@HRM');
Route::post('reg','ProcessController@reg')->name('reg');  ; 
Route::post('login','ProcessController@login')->name('login');  
Route::get('logout','ProcessController@logout')->name('logout');  


/////////////////////////////////////////video
Route::group(['prefix'=>'/index','namespace' => 'Video','middleware'=>'auth'],function(){
    Route::get('/',function (){return view('index',['title'=>'歡迎使用影像調閱系統']);})->name('index');
});

Route::group(['prefix'=>'replay','namespace' => 'Video','middleware'=>'auth'],function(){
    Route::get('/', 'CamdbController@replay')->name('replay');
    Route::get('/select_goup/{goup_id}','CamdbController@show_in_replay');
});
Route::group(['prefix'=>'playrealtime','namespace' => 'Video','middleware'=>'auth'],function(){
    Route::get('/', 'CamdbController@play')->name('playrealtime');
    Route::get('/select_goup/{goup_id}','CamdbController@show_in_playrealtime');
});

Route::group(['prefix'=>'configcam','namespace' => 'Video','middleware'=>'auth'],function (){
    Route::get('/', 'CamdbController@config')->name('configcam');
});

Route::group(['prefix'=>'recordconfig','namespace' => 'Video','middleware'=>'auth'],function (){
    Route::get('/','CamdbController@record')->name('recordconfig');
    Route::get('/{cam_id}','CamdbController@find_channel');
    Route::get('/get_info/{cam_list}','CamdbController@get_info');
    Route::get('/select_goup/{goup_id}','CamdbController@show_in_recordconfig');
});

Route::get('login',function(){
    return redirect('/');
});  

/////////////////////////////////////////smart_parking
Route::group(['prefix'=>'iswhite','namespace' => 'Parking','middleware' => 'auth'],function (){
    Route::get('/','AdminlpsController@index')->name('iswhite');
    Route::get('/seletall','AdminlpsController@seletall');
    Route::get('/{fun}','AdminlpsController@sort');
    Route::get('/search/{Lps}','AdminlpsController@sort');
    Route::get('/setting/{LP}','AdminlpsController@unban');
});

Route::group(['namespace' => 'Parking','middleware' => 'auth'],function (){
    Route::get('/dashboard','IndexController@index')->name('dashboard');
    Route::get('/camera','CameraController@callapi')->name('camera');
    // Route::get('/log_out','UserController@logout')->name('logout');

    Route::get('/account','UserController@account_index')->name('account');
    Route::post('/account','UserController@insert');

    Route::get('/free/parking/space','UserController@free_parking_space');
});
// 回放
Route::get('/playback',function(){
    return view('playback');
});

///////////////////////////////////////////HRM
// Route::group(['prefix'=>'HRM'],function (){
//     Route::get('/','PageController@HRM');
//     Route::get('human_management','PageController@HRM');
//     Route::get('HRM','PageController@HRM');
// });

Route::group(['prefix'=>'people'],function (){
    Route::get('/','PageController@people');
    Route::post('/insert','InsertController@insert')->name('insert'); 
    Route::post('/delete','InsertController@delete')->name('delete');
    Route::post('/update','InsertController@update')->name('update');

});


Route::group(['prefix'=>'docker'],function (){
    Route::group(['prefix'=>'new'],function (){
        Route::get('/','PageController@new');
        Route::post('/service_create','DockerController@container_create')->name('container_create');
    });

    Route::group(['prefix'=>'service'],function (){
        Route::get('/','DockerController@init');
  
    });
    
    Route::group(['prefix'=>'admin_service'],function (){
        Route::get('/','DockerController@admin_service');
    
    });
    
    Route::post('api','DockerController@ctrl_docker_service')->name('api');

});




