@extends('layouts.template')

@section('title', 'Insert new service')

@section('navbar_content')
    @include('docker.layouts.navbar_li')
@stop

@section('content')
<div class="thumbnail">
    <h1>後台管理</h1>
    <div class="row justify-content-center">
        <form class="col-8" action="{{route('container_create')}}" method="post">
        <input type = "hidden" name = "_token" value = "<?php echo csrf_token(); ?>">
            <div class="form-group row">
                <label for="inputEmail3" class="col-sm-2 col-form-label">模組名稱</label>
                <div class="col-sm-10">
                    <input name="module_name" pattern="^[a-zA-Z0-9]{3,}$" class="form-control" type="text" placeholder="請輸入英文或數字共3個字以上" required="">
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-2 col-form-label">辨識模組</label>
                <div class="col-sm-10">
                    <select id="module" class="form-control" name="identify_module">
                    <option value="none" selected="">請選擇一個模組</option>
                    @foreach($docker_tag as $tag)
                        <option value="{{$tag['RepoTags'][0]}}">{{$tag['RepoTags'][0]}}</option>
                    @endforeach
                    </select>
                </div>
            </div>

            <div class="add"></div>

            <!-- <div class="form-group row">
                <label class="col-sm-2 col-form-label">來源串流</label>
                <div class="col-sm-10">
                    <select class="form-control" name="origin_stream">
                    @foreach($total_stream as $stream)
                        <option>{{$stream['path']}}</option>
                    @endforeach
                    </select>
                </div>
            </div>
            <div class="form-group row">
                <label class="col-sm-2 col-form-label">目的串流</label>
                <div class="col-sm-10">
                    <input name="dis_stream" class="form-control" type="text" placeholder="請輸入英文或數字共3個字以上" class="input-large" value="rtsp://192.168.5.208:554/test" required="">
                </div>
            </div> -->
            
            <!-- <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">辨識範圍</label>
                <div class="col-sm-10">
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="validatedCustomFile" name="identify_area" >
                        <label class="custom-file-label" for="validatedCustomFile">Choose file...</label>
                        <div class="invalid-feedback">Example invalid custom file feedback</div>
                    </div>
                </div>
            </div> -->
                          
            <!-- <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">辨識模組</label>
                <div class="col-sm-10">
                    <div class="custom-file">
                        <input type="file" class="custom-file-input" id="validatedCustomFile">
                        <label class="custom-file-label" for="validatedCustomFile">Choose file...</label>
                        <div class="invalid-feedback">Example invalid custom file feedback</div>
                    </div>
                </div>
            </div> -->
            
            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">是否輸出</label>
                  <div class="col-sm-10">
                    <div class="form-check form-check-inline">
                        <div class="custom-control custom-radio custom-control-inline">
                          <input type="radio" class="custom-control-input" id="customRadio3" name="example">
                          <label class="custom-control-label" for="customRadio3">是</label>
                        </div>
                    <div class="form-check form-check-inline">
                        <div class="custom-control custom-radio custom-control-inline">
                          <input type="radio" class="custom-control-input" id="customRadio4" name="example" checked="">
                          <label class="custom-control-label" for="customRadio4">否</label>
                        </div>
                    </div>
                    </div>
                  </div>
            </div>

            <div class="form-group row">
                <label for="inputPassword3" class="col-sm-2 col-form-label">是否啟動</label>
                <div class="col-sm-10">
                    <div class="form-check form-check-inline">
                        <div class="custom-control custom-radio custom-control-inline">
                            <input type="radio" class="custom-control-input" id="customRadio" name="radio_start" value="Y">
                            <label class="custom-control-label" for="customRadio">是</label>
                        </div>
                    <div class="form-check form-check-inline">
                        <div class="custom-control custom-radio custom-control-inline">
                            <input type="radio" class="custom-control-input" id="customRadio1" name="radio_start" checked="" value="N">
                            <label class="custom-control-label" for="customRadio1">否</label>
                        </div>
                        </div>
                    </div>
                </div>
            </div>
            <div style="text-align:center">
                <button  type="submit" class="btn btn-primary">新增</button>
                <button type="reset" class="btn btn-primary">取消</button>
            </div>
        </form>
    </div>
</div>

@stop

@section('script')
<script>
$("#module").change(function(){
    
    switch ($(this).val()){

        case 'docker-lpr:latest': 
            console.log($(this).val());
            $( ".add" ).empty();
            var str='';

            str+=("<div class=\"form-group row\" id=\"stream\" >");
            str+=("<label class=\"col-sm-2 col-form-label\" >"+"STREAM"+"</label>");
            str+=("<div class=\"col-sm-10\" >");
            str+=("<input name=\"STREAM\" class=\"form-control\" type=\"text\" placeholder=\"請輸入英文或數字共3個字以上\" value=\"rtsp://admin:Ecom84253675@120.108.24.89:554/onvif/profile2/media.smp\" required=\"\">");
            str+=("</div>");
            str+=("</div>");

            str+=("<div class=\"form-group row\" id=\"channel\" >");
            str+=("<label class=\"col-sm-2 col-form-label\" >"+"channel"+"</label>");
            str+=("<div class=\"col-sm-10\" >");
            str+=("<input name=\"channel\" class=\"form-control\" type=\"text\" value=\"mmout\" required=\"\">");
            str+=("</div>");
            str+=("</div>");

            str+=("<div class=\"form-group row\" id=\"tsdbserver\" >");
            str+=("<label class=\"col-sm-2 col-form-label\" >"+"TSDBSERVER"+"</label>");
            str+=("<div class=\"col-sm-10\" >");
            str+=("<input name=\"TSDBSERVER\" class=\"form-control\" type=\"text\" value=\"192.168.5.17\" required=\"\">");
            str+=("</div>");
            str+=("</div>");

            str+=("<div class=\"form-group row\" id=\"tsdbport\" >");
            str+=("<label class=\"col-sm-2 col-form-label\" >"+"TSDBPORT"+"</label>");
            str+=("<div class=\"col-sm-10\" >");
            str+=("<input name=\"TSDBPORT\" class=\"form-control\" type=\"text\" value=\"8086\" required=\"\">");
            str+=("</div>");
            str+=("</div>");
            $( ".add" ).append(str);

        break;

        case 'ffmpeg-transfer:latest': 
            $( ".add" ).empty();
            var str='';
            var total_stream=<?php echo json_encode($total_stream); ?>;

            str+=("<div class=\"form-group row\" id=\"origin\">");
            str+=("<label class=\"col-sm-2 col-form-label\" >"+"來源串流"+"</label>");
            str+=("<div class=\"col-sm-10\">");
            str+=("<select class=\"form-control\" name=\"origin_stream\">");
            for(var i=0; i<total_stream.length; i++){
                str+=("<option>"+total_stream[i]['path']+"</option>");
            }
            str+=("</select>");
            str+=("</div>");
            str+=("</div>");

            str+=("<div class=\"form-group row\" id=\"dis\" >");
            str+=("<label class=\"col-sm-2 col-form-label\" >"+"目的串流"+"</label>");
            str+=("<div class=\"col-sm-10\" >");
            str+=("<input name=\"dis_stream\" class=\"form-control\" type=\"text\" placeholder=\"請輸入英文或數字共3個字以上\" value=\"rtsp://192.168.5.208:554/test\" required=\"\">");
            str+=("</div>");
            str+=("</div>");
            $( ".add" ).append(str);
        break;

        default:
        $( ".add" ).empty();
        // $( "#channel" ).remove();
        // $( "#tsdbserver" ).remove();
        // $( "#tsdbport" ).remove();
        // $( "#origin" ).remove();
        // $( "#dis" ).remove();
        

        }
});
</script>
@stop