@extends('layouts.template')

@section('title', 'Camera')

@section('header1')
    <link href="https://cdnjs.cloudflare.com/ajax/libs/video.js/6.6.2/video-js.min.css" rel="stylesheet">
    <script src="https://cdnjs.cloudflare.com/ajax/libs/video.js/6.6.2/video.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/video.js/6.6.2/ie8/videojs-ie8.min.js"></script>
    <!-- videojs-flash -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/videojs-flash/2.1.0/videojs-flash.min.js"></script>
    <script>
        videojs.options.flash.swf = "https://cdnjs.cloudflare.com/ajax/libs/video.js/6.6.2/video-js.swf"
    </script>
    <link rel="stylesheet" href="{{asset('css/templatemo-style.css')}}">
@stop

@section('navbar_content')
    @include('smart_parking.layouts.navbar_li')
@stop

@section('content')
    <div class="container mt-5">
        <div class="row tm-content-row">
            <div class="col-sm-12 col-md-12 col-lg-8 col-xl-8 tm-block-col">
            <!-- <div class="thumbnail"> -->
                <div class="tm-bg-primary-dark tm-block tm-block-products">
                    <div class="row">
                        <div class="col-sm-8">
                            <select id="stream_option" class="form-control" name="identify_module">
                                @foreach($docker_tag as $content)
                                    @if(isset($content['Labels']['des_stream']))
                                        <option>{{$content['Labels']['des_stream']}}</option>
                                    @endif
                                @endforeach
                            </select>
                        </div>

                    </div>
       
                    <br>
                    <div class="embed-responsive embed-responsive-4by3">
                        <video id="my-video" class="video-js embed-responsive-item" data-setup='{ "autoplay" : true , "controls" : "true" , "poster" : "true" , "preload" : "auto"  ,"techOrder":["html5", "flvjs", "flash"]}'>
                            <source  id = "url" src = "http://192.168.5.17/live/in.flv"  type='video/flv'>

                            <p class="vjs-no-js">
                                <!-- 如果使用者不支援JavaScript，顯示這段-->
                                To view this video please enable JavaScript, and consider upgrading to a web browser that
                                <a href="http://videojs.com/html5-video-support/" target="_blank">supports HTML5 video</a>
                            </p>
                        </video>
                    </div>

                    <h3 id="AreaBox" class ='font-weight-bold col-6'>入口</h3>
                    <br>
                <!-- </div> -->
                </div>
            </div>
            <div class="col-sm-10 col-md-10 col-lg-4 col-xl-4 tm-block-col">
                <div class="tm-bg-primary-dark tm-block tm-block-products">
                    <h1 id= "RtmpName"></h1>
                    <div class="list-group">
                        <div class="card card-outline-secondary my-4">
                            <div class="card-header text-center font-weight-bold">
                                辨識結果
                            </div>
                            <div style="color:#000" class="card-body">
                                <p class = 'font-weight-bold'>車牌影像：</p>
                                <td>
                                    <img  style="width: 70%" id="img" src="">
                                </td>
                                <hr>
                                <p class = 'font-weight-bold t'>車牌字符：</p>
                                <td >
                                    <p id="lp">lp</p>
                                </td>
                                <hr>
                                <p class = 'font-weight-bold'>時間：</p>
                                <th scope="row">
                                    <p id ='time'>time</p>
                                </th>
                                <hr>
                                <p class = 'font-weight-bold'>管院車輛剩餘：</p>
                                <div id="free-parking-space" class="alert alert-info"style="font-size: 40px;text-align: center;margin: 30px" role="alert">
                                    {{$Cars}}
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="tm-product-table-container">
                        <table class="table tm-table-small tm-product-table"></table>
                    </div>
                </div>
            </div>
        </div>
    </div>
@endsection

@section('script')
    <script>
        $(function() {
            $(".tm-product-name").on("click", function() {
                window.location.href = "edit-product.html";
            });
        });
    </script>
    {{--自動更新 辨識結果 剩餘車位數--}}
    <script>
        var stream="inter";
        var interval=1000;
        var getplate = function(){
            if (stream === "inter"){
                $.ajax({
                    // url: 'http://192.168.5.17:8086/query?q=select+last(plate)%2C*+from+%22in%22&db=NCUT_MM&pretty=true',
                    url: 'http://192.168.5.17:8086/query?q=select++last(plate)+from+mmin&db=LPR&pretty=true',
                    success:function (data) {
                        var time=data.results[0].series[0].values[0][0].split(".")[0];
                        var img=data.results[0].series[0].values[0][1];
                        var lp=data.results[0].series[0].values[0][1];
                        let UTCTimeObj = new Date(time=time+'z');
                        document.getElementById("time").innerHTML = UTCTimeObj.toLocaleString();
                        document.getElementById('img').src='http://192.168.5.103:8001/result?filename='+img;
                        console.log(lp);
                        document.getElementById("lp").innerHTML = lp;
                    },
                    complete: function () {
                        // Schedule the next
                        setTimeout(getplate, interval);
                    }
                });
            }else if (stream === "outer"){
                $.ajax({
                    // url: 'http://192.168.5.17:8086/query?q=select+last(plate)%2C*+from+%22out%22&db=NCUT_MM&pretty=true',
                    url: 'http://192.168.5.17:8086/query?q=select++last(plate)+from+mmout&db=LPR&pretty=true',
                    success:function (data) {
                        var time=data.results[0].series[0].values[0][0].split(".")[0];
                        var img=data.results[0].series[0].values[0][1];
                        var lp=data.results[0].series[0].values[0][1];
                        let UTCTimeObj = new Date(time=time+'z');
                        document.getElementById("time").innerHTML = UTCTimeObj.toLocaleString();
                        document.getElementById('img').src =' http://192.168.5.103:8001/result?filename='+img;
                        document.getElementById("lp").innerHTML = lp;
                    },
                    complete: function () {
                        // Schedule the next
                        setTimeout(getplate, interval);
                    }
                });
            }

        };
        var freespace=function(){
            $.ajax({
                url: '/free/parking/space',
                success:function (data) {
                    document.getElementById("free-parking-space").innerText=data;
                },
                complete: function () {
                    // Schedule the next
                    setTimeout(freespace, interval);
                }
            });
        };
        var startdemo=function(){
            $.ajax({
                url:'http://192.168.5.103:8001/demo',
                success:function(){
                },
                complete: function () {
                    setTimeout(demo_stream,2000);
                }
            })
        }
        freespace();
        getplate();
    </script>
    {{--串流切換--}}
    <script>
        function inter_stream() {
            document.getElementById("AreaBox").innerHTML='入口';
            document.getElementById("RtmpName").innerHTML='Rtmp-Play0';
            let player=videojs("my-video");
            player.src("http://192.168.5.17/live/in.flv");
            player.play();
            stream="inter";
        }
        function outer_stream() {
            // document.getElementById("AreaBox").innerHTML='出口';
            // document.getElementById("RtmpName").innerHTML='Rtmp-Play1';
            let player=videojs("my-video");
            player.src("http://192.168.5.17/live/out.flv");
            player.play();
            stream="outer";
        }
        function processFormData() {
            document.getElementById("AreaBox").innerHTML='自定義';
            document.getElementById("RtmpName").innerHTML='Rtmp-Play2';
            var name_element = document.getElementById('src');
            var src = name_element.value;
            alert('你的網址是' + src);
            let player=videojs("my-video");
            player.src(src);
            player.play();
        }
        function demo_stream() {
            alert('demo start!');
            document.getElementById("AreaBox").innerHTML='demo';
            document.getElementById("RtmpName").innerHTML='Rtmp-Play3';
            let player=videojs("my-video");
            player.src("http://192.168.5.17/live/demo.flv");
            player.play();
            stream="outer";
        }


    $("#stream_option").change(function(){
        outer_stream();
    });
    </script>
@stop