@extends('layouts.template')

@section('title', 'Dashboard')

@section('navbar_content')
    @include('smart_parking.layouts.navbar_li')
@stop

@section('content')
<div class="" id="home">
    <div class="container">
        <div class="row">
            <div class="col">
                <p class="text-white mt-5 mb-5">Welcome back,
                    <b>{{ \Illuminate\Support\Facades\Auth::user()->name }}</b>
                </p>
            </div>
        </div>
        <!-- row -->
        <div class="row tm-content-row">
            <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 tm-block-col">
                <div class="embed-responsive embed-responsive embed-responsive-4by3">
                    <iframe class="embed-responsive-item"
                            src="http://192.168.5.17:3000/d/2qwA9x3mz/demo?orgId=1&fullscreen&panelId=2&from=now%2Fd&to=now%2Fd"></iframe>
                </div>
            </div>
            <div class="col-sm-12 col-md-12 col-lg-6 col-xl-6 tm-block-col">
                <div class="embed-responsive embed-responsive embed-responsive-4by3">
                    <iframe class="embed-responsive-item"
                            src="http://192.168.5.17:3000/d/2qwA9x3mz/demo?orgId=1&fullscreen&panelId=4&from=now%2Fd&to=now%2Fd"></iframe>
                </div>
            </div>
            <div class="col-lg-3"></div>
            <div class="col-sm-12 col-md-12 col-lg-6 tm-block-col">
                <div class="embed-responsive embed-responsive embed-responsive-4by3">
                    <iframe class="embed-responsive-item"
                            src="http://192.168.5.17:3000/d/2qwA9x3mz/demo?panelId=6&fullscreen&tab=visualization&orgId=1&from=now%2Fd&to=now%2Fd"></iframe>
                </div>
            </div>
            <div class="col-lg-3"></div>
            <div class="col-12 tm-block-col">
                <div class="tm-bg-primary-black tm-block tm-block-taller tm-block-scroll">
                    <div class="row">
                    <h2 class="tm-block-title">當前進入車輛</h2>
                    <table class="table table-dark">
                        <thead>
                        <tr>
                            <th scope="col">進入時間</th>
                            <th scope="col">車牌號碼</th>
                            <th scope="col">快照</th>
                        </tr>
                        </thead>
                        <tbody>
                        <tr>
                            <th scope="row" id="inter-time">
                                times
                            </th>
                            <td id="inter-lp">
                                lp
                            </td>
                            <td>
                                <img id="inter-img" src="">
                            </td>
                        </tr>
                        </tbody>
                    </table>
                    </div>
                    <div>
                        <h2 class="tm-block-title">當前離開車輛</h2>
                        <table class="table table-dark">
                            <thead>
                            <tr>
                                <th scope="col">離開時間</th>
                                <th scope="col">車牌號碼</th>
                                <th scope="col">快照</th>
                            </tr>
                            </thead>
                            <tbody>
                            <tr>
                                <th scope="row" id="outer-time">
                                    times
                                </th>
                                <td id="outer-lp">
                                    lp
                                </td>
                                <td>
                                    <img id="outer-img" src="">
                                </td>
                            </tr>
                            </tbody>
                        </table>
                    </div>
                </div>
            </div>
            <div class="embed-responsive embed-responsive embed-responsive-21by9">
                <iframe class="embed-responsive-item" src="http://192.168.5.17:3000/d/j59hUIWZk/lpr-system?orgId=1&refresh=1m&kiosk"></iframe>
            </div>


        </div>
    </div>
</div>
@stop

@section('script')

<script>
    document.body.style.background = '#090909';
        var interval=1000;
        var doAjax = function() {
            $.ajax({
                url: 'http://192.168.5.17:8086/query?q=select+last(%22plate%22)+from+%22test%22&db=LP&pretty=true',
                success: function(data){
                    document.getElementById("inter-time").innerHTML=data.results[0].series[0].values[0][0];
                    document.getElementById("inter-lp").innerHTML=data.results[0].series[0].values[0][1];
                    console.log(innerHTML=data.results[0].series[0].values[0][1]);
                },
                complete: function () {
                    // Schedule the next
                    setTimeout(doAjax, interval);
                }
            });
        };

        var getinplate=function(){
            $.ajax({
               url: 'http://192.168.5.17:8086/query?q=select+last(plate)%2C*+from+%22in%22&db=NCUT_MM&pretty=true',
               success:function (data) {
                   var time=data.results[0].series[0].values[0][0].split(".")[0];
                   var img=data.results[0].series[0].values[0][1];
                   var lp=data.results[0].series[0].values[0][3];
                   let UTCTimeObj = new Date(time=time+'z');
                   document.getElementById("inter-time").innerHTML = UTCTimeObj.toLocaleString();
                   document.getElementById('inter-img').src =' http://192.168.5.53:8001/result?filename='+img;
                   document.getElementById("inter-lp").innerHTML = lp;
               },
                complete: function () {
                    // Schedule the next
                    setTimeout(getinplate, interval);
                }
            });
        };

        var getoutplate=function(){
            $.ajax({
                url: 'http://192.168.5.17:8086/query?q=select+last(plate)%2C*+from+%22out%22&db=NCUT_MM&pretty=true',
                success:function (data) {
                    var time=data.results[0].series[0].values[0][0].split(".")[0];
                    var img=data.results[0].series[0].values[0][1];
                    var lp=data.results[0].series[0].values[0][3];
                    let UTCTimeObj = new Date(time=time+'z');
                    document.getElementById("outer-time").innerHTML = UTCTimeObj.toLocaleString();
                    document.getElementById('outer-img').src =' http://192.168.5.53:8001/result?filename='+img;
                    document.getElementById("outer-lp").innerHTML = lp;
                },
                complete: function () {
                    // Schedule the next
                    setTimeout(getoutplate, interval);
                }
            });
        };
        getinplate();
        getoutplate();
</script>
@stop
