@extends('layouts.template')

@section('title', '攝影機設定')

@section('navbar_content')
    @include('docker.layouts.navbar_li')
@stop

@section('content')
<style>

.closebtn {
  margin-left: 15px;
  color: white;
  font-weight: bold;
  float: right;
  font-size: 22px;
  line-height: 20px;
  cursor: pointer;
  transition: 0.3s;
}

.closebtn:hover {
  color: black;
}
</style>



@if ($alert !=="")
  @if ($alert =="insertfail")
  <div class="alert alert-danger">
    <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span> 
    <strong>新增失敗!</strong> 請確定資料輸入正確或串流是否啟用。
  </div>
  @elseif ($alert =="insertsuc")
  <div class="alert alert-success">
    <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span>  
    <strong>新增成功!</strong> 已將串流新增至資料庫。
  </div>
  @elseif ($alert =="updatefail")
  <div class="alert alert-danger">
    <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span> 
    <strong>更新失敗!</strong> 請確定更新的資料是否輸入正確或串流是否啟用。
  </div>  
  @elseif ($alert =="updatesuc")
  <div class="alert alert-success">
    <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span>  
    <strong>更新成功!</strong> 已成功將{{$selectid}}號攝影機資料更新。   
  </div>
  @elseif ($alert =="delete")
  <div class="alert alert-success">
    <span class="closebtn" onclick="this.parentElement.style.display='none';">&times;</span>  
    <strong>刪除成功!</strong> 已成功將{{$selectid}}號攝影機資料刪除。   
  </div>  
  @elseif ($alert =="streamfail")
  <div class="alert alert-warning " role="alert">
    <button type="button" class="close" data-dismiss="alert" aria-label="Close">
      <span aria-hidden="true">&times;</span>
    </button>
    <strong>目的錯誤!</strong> 已成功將攝影機新增置資料庫，但目的位置錯誤，無法拋轉。   
  </div>
  @endif
@endif

<!-- 新增資料欄位 -->
<div class="col-lg-12">
  <div class="thumbnail">
    <form action="{{ url("/caminsert") }}" method='post'  >
      {{ csrf_field() }}
      <input type="hidden" name="_token" value="<?php echo csrf_token(); ?>"> 
      
      <div class="form-row" >
        <div class="form-group col-md-6" >
          <label for="inputcamid">攝影機編號</label>
          <input type="text" class="form-control" name="inputcamid" value=<?php echo $lastcamid+1 ;?> readonly="readonly" >
          
        </div>
        <div class="form-group col-md-6">
          <label for="inputcamip">串流位置</label>
          <input type="text" class="form-control" name="inputcamip" placeholder="rtsp://123.123.123.123">
        </div>
      </div>
      <div class="form-row" >
        <div class="form-group col-md-6" >
          <label for="inputcamname">位置名稱</label>
          <input type="text" class="form-control" name="inputcamname" placeholder="西門入口">
        </div>
        <div class="form-group col-md-6">
          <label for="inputdesip">目的串流位置</label>
          <div class="input-group mb-2">
            <div class="input-group-prepend">
              <div class="input-group-text">rtmp://192.168.5.17:1935/</div>
            </div>
            <input type="text" class="form-control" name="inputdesip" placeholder="yu/video1">
          </div>
        </div>
      </div>
      <div class="form-row" >
        <div class="form-group col-md-2" >
          <button  type="submit" class="btn btn-primary" id="demo">新增攝影機 </button>
        </div>
      </div>
    </form>

  </div>
</div>

<!-- 攝影機資料table -->
<table class="table table-bordered" style="color:#fff" >
  <thead>
    <tr>
      <th  scope="col">id</th>
      <th  scope="col">位置名稱</th>
      <th  scope="col">串流位置</th>
      <th  scope="col">目的串流位置</th>
      <th  scope="col">圖片位置</th>
      <th  scope="col">目前狀態</th>
      <th  scope="col">備註</th>
    </tr>
  </thead>
  <tbody id="Mytable">
@if ($countid > 0)
 @foreach ($camall as $camall)
 <tr>
    <td scope="row">{{$camall->id}} </td>
    <td >{{$camall->name}} </td>
    <td >{{$camall->ip}} </td>
    <td >{{$camall->desip}} </td>
    <td >{{$camall->picsite}} </td>
    <td >{{$camall->status}} </td>
    <td >
        
        <form action="{{ url("/camdelete") }}" method="POST">
        {{ csrf_field() }}
        <input type = "hidden" name = "camid" value = "{{$camall->id}}">
         <!--彈出修改視窗 Button trigger modal -->
        <button type="button" class="btnSelect btn btn-primary" data-toggle="modal" data-target="#exampleModal" >
          修改
        </button>

        <a  id="contact_weixin" onclick="opencanvas(this)">
        <button type="button" class="snapshot btn btn-primary" value="{{$camall->id}}" name="popuppicbtn"  data-toggle="modal" data-target="#popupcanvas">
          快照
        </button>
        </a>

        <button type="submit" class="btn btn-danger" value="{{$camall->id}}" name="deletecambtn"> 刪除 </button>
        
        </form> 
        
  </tr>
 @endforeach
 
@endif
    </tbody>
   
</table>

<!--/////////////////////////////////////////// 顯示選取資料 -->
<div id="output"></div>



<!--'修改'彈出視窗的內容 Modal -->
<div class="modal fade" id="exampleModal" tabindex="-1" role="dialog" aria-labelledby="exampleModalLabel" aria-hidden="true">
  <div class="modal-dialog" role="document">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="exampleModalLabel">修改攝影機資料</h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <form action="{{ url("/camupdate") }}" method="POST"> 
      {{ csrf_field() }}
      <div class="modal-body">
      <label>攝影機編號</label>
      <input type="text" class="form-control" name="updatecamid" id="updatecamid" readonly="readonly" >
      <label >位置名稱</label>
      <input type="text" class="form-control" name="updatecamname" id="updatecamname" placeholder="西門入口">
      <label >串流位置</label>
      <input type="text" class="form-control" name="updatecamip" id="updatecamip" placeholder="rtsp://123.123.123.123">      
      <label >目的串流位置</label>
      <div class="input-group mb-2">
        <div class="input-group-prepend">
          <div class="input-group-text">rtmp://192.168.5.17:1935/</div>
        </div>
        <input type="text" class="form-control" name="updatecamdesip" id="updatecamdesip" placeholder="yu/video1">
      </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-secondary" data-dismiss="modal">取消</button>
        <button type="submit" class="btn btn-primary">確定修改</button>
      </div>
      </form>
    </div>
  </div>
</div>

<!-- 給'修改'彈出視窗資料的java script -->
<script>
 $(document).ready(function(){

// code to read selected table row cell data (values).
$("#Mytable").on('click','.btnSelect',function(){
     // get the current row
     var currentRow=$(this).closest("tr"); 
     
     var col0=currentRow.find("td:eq(0)").html();
     var col1=currentRow.find("td:eq(1)").html(); // get current row 2nd table cell TD value
     var col2=currentRow.find("td:eq(2)").html(); // get current row 3rd table cell  TD value
     var col3=currentRow.find("td:eq(3)").html();
     
   
     $('#updatecamid').val(col0.trim());
     $('#updatecamname').val(col1.trim());
     $('#updatecamip').val(col2.trim());
     $('#updatecamdesip').val(col3.replace(new RegExp('rtmp://192.168.5.17:1935/', 'g'), '').trim());
   


});
});
</script>
<!-- 給canvas彈出視窗id -->
<script>
 $(document).ready(function(){

// code to read selected table row cell data (values).
$("#Mytable").on('click','.snapshot',function(){
     // get the current row
     var currentRow=$(this).closest("tr"); 
     
     var col0=currentRow.find("td:eq(0)").html();   
     $('#canvas_id').val(col0.trim());
     
});
});
</script>

<!-- 'canvas'的彈出視窗 -->
<div class="container">
  <!-- The Modal -->
  <div class="modal fade" id="popupcanvas">
    <div class="modal-dialog modal-xl">
      <div class="modal-content">
      
        <!-- Modal Header -->
        <div class="modal-header">
          <h4 class="modal-title">選取熱區，若劃出畫框則要重劃</h4>
          <button type="button" class="close" data-dismiss="modal">&times;</button>
        </div>
        <form action="{{ url("/canvas_set") }}" method="POST"> 
         {{ csrf_field() }}
        <!-- Modal body -->
        <div class="modal-body">
        <canvas id="canvas"  width="800" height="430" style="border:3px solid #000000;"></canvas>
        <div id="output"></div>
        </div>
        <input type="hidden" class="form-control" name="canvas_id" id="canvas_id" placeholder="...">   
        <input type="hidden" class="form-control" name="start_x" id="start_x" placeholder="0">   
        <input type="hidden" class="form-control" name="start_y" id="start_y" placeholder="1">
        <input type="hidden" class="form-control" name="end_x" id="end_x" placeholder="254">   
        <input type="hidden" class="form-control" name="end_y" id="end_y" placeholder="255">   
        <!-- Modal footer -->
        <div class="modal-footer">
          <button type="reset" class="btn btn-secondary" data-dismiss="modal">取消</button>
          <button type="submit" class="btn btn-primary">確定</button>
        </div>
        </form>
      </div>
    </div>
  </div>
  
</div>


<!-- 取得快照圖片位置的java script -->
<script>
//全域變數
var canvas = document.getElementById("canvas");
  //创建image对象
var image1 = new Image();

var ctx = canvas.getContext('2d');

// 當碰到按鈕時，將資料表的位置資料抓出來
$("#Mytable").on('mouseover','.snapshot',function(){
     // get the current row
     var currentRow=$(this).closest("tr"); 
     
     var  picsite=currentRow.find("td:eq(4)").html();//找第四行   
      
      // var picsite=document.getElementById("getpicsite").value;
      var strpicsite="{{ URL::asset('campic/001.jpg') }}";
      chgpicsite=strpicsite.replace("campic/001.jpg",picsite);
      image1.src = chgpicsite;        
});


//當點擊快照按鈕時，改變canvas的IMG
function opencanvas(obj){ /*click執行區*/
        
        
        // //获取画布的宽和高
        // var width=canvas.getAttribute("width")
        // var height=canvas.getAttribute("height");

        // //重新设置画布的大小
        // width=parseInt(width)+100
        // height=parseInt(height)+100
        // canvas.setAttribute("width",width)
        // canvas.setAttribute("height",height)

        //讀取圖片大小
        // image1.onload = function() {
        //     alert(this.width + 'x' + this.height);
        // }
        
        //创建image对象
        image1 = new Image();
        image1.src = chgpicsite;
        ctx = canvas.getContext('2d'); 
        //計算縮放比例       
        img_scale=800/image1.width;
        //重設畫布大小
        canvas.setAttribute("height",image1.height*img_scale);
        //畫布顯示圖片
        ctx.drawImage(image1,0,0,800,image1.height*img_scale);//顯示原本圖片
    }
    




//canvas的js
  
//canvas劃出框線並算出起始及最終位置
  
   
  // ctx.drawImage(this, 0, 0);//this即是imgObj,保持图片的原始大小
  // ctx.drawImage(image1, 0, 0,900,500);//改变图片的大小到900*500
  // ctx.drawImage(image1,0,0,944,480);//顯示原本圖片
      

  //Canvas
  //var canvas = document.getElementById('canvas');
  //var ctx = canvas.getContext('2d');
  //Variables
  var canvasx = $(canvas).offset().left;
  var canvasy = $(canvas).offset().top;
  var move_mousex = move_mousey = 0;
  var end_mousex = end_mousey = 0;
  var start_mousex = start_mousey = 0;
  var mousex = mousey = 0;
  var mousedown = false;

  //Mousedown
  $(canvas).on('mousedown', function(e) {
      //有CSS改變位置時使用上面的程式
      // move_mousex = parseInt(e.clientX-canvasx-parseInt($('canvas').css('left'), 10));
      // move_mousey = parseInt(e.clientY-canvasy-parseInt($('canvas').css('top'), 10));
      //$('canvas').css('border').substr(0,3)為取得邊框的字串，從第0位開始取3個字
      var rect = canvas.getBoundingClientRect();
      move_mousex = parseInt(e.clientX-rect.left-parseInt($('canvas').css('border').substr(0,3), 10));
      move_mousey = parseInt(e.clientY-rect.top-parseInt($('canvas').css('border').substr(0,3), 10));
      
      start_mousex=parseInt(move_mousex/img_scale);
      start_mousey=parseInt(move_mousey/img_scale);
      $('#start_x').val(start_mousex);
      $('#start_y').val(start_mousey);
      
      mousedown = true;

  });

  //Mouseup
  $(canvas).on('mouseup', function(e) {
      
      mousedown = false;
      end_mousex=parseInt(mousex/img_scale);
      end_mousey=parseInt(mousey/img_scale);
      $('#end_x').val(end_mousex);
      $('#end_y').val(end_mousey);
  });

  //Mousemove
  $(canvas).on('mousemove', function(e) {
      //有CSS改變位置時使用上面的程式
      // mousex = parseInt(e.clientX-canvasx-parseInt($('canvas').css('left'), 10));
      // mousey = parseInt(e.clientY-canvasy-parseInt($('canvas').css('top'), 10));
      //$('canvas').css('border').substr(0,3)為取得邊框的字串，從第0位開始取3個字
      var rect =canvas.getBoundingClientRect();
      mousex = parseInt(e.clientX-rect.left-parseInt($('canvas').css('border').substr(0,3), 10));
      mousey = parseInt(e.clientY-rect.top-parseInt($('canvas').css('border').substr(0,3), 10));
      
      if(mousedown) {
          
          ctx.clearRect(0,0,canvas.width,canvas.height); //clear canvas
          // ctx.drawImage(this, 0, 0);//this即是imgObj,保持图片的原始大小
          // ctx.drawImage(image1, 0, 0,900,500);//改变图片的大小到900*500
          ctx.drawImage(image1,0,0,800,image1.height*img_scale);//顯示原本圖片
          
          ctx.beginPath();
          var width = mousex-move_mousex;
          var height = mousey-move_mousey;
          ctx.rect(move_mousex,move_mousey,width,height);
          ctx.strokeStyle = 'green';
          ctx.lineWidth = 7;
          ctx.stroke();
          
      }
      //Output
      // $('#output').html('結束: '+end_mousex+', '+end_mousey+'<br/>開始: '+start_mousex+', '+start_mousey+'<br/>mousedown: '+mousedown);
  });

</script>




@stop
